package ru.yandex.autotests.direct.api.ads.add.mobileappadbuilderad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdBuilderAdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.VideoExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.VideoExtensionUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldMustBePositiveInteger;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;

/**
 https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка работы поля CreativeId")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
@RunWith(Parameterized.class)
public class AddMobileAppAdBuilderAdCreativeValidationNegativeTest {
    private static String LOGIN = AdsLogins.CLIENT;
    private static Long NEGATIVE_ID = -1L;
    private static Long ZERO_ID = 0L;
    private static Long ANOTHER_CLIENT_CREATIVE_ID = 123L;
    private static Long adGroupId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameter(0)
    public AdBuilderAdAddItemMap creative;

    @Parameter(1)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {new AdBuilderAdAddItemMap().withCreativeId(NEGATIVE_ID),
                        fieldMustBePositiveInteger(capitalize(VideoExtensionAddItemMap.CREATIVE_ID))},
                {new AdBuilderAdAddItemMap().withCreativeId(ZERO_ID),
                        fieldMustBePositiveInteger(capitalize(VideoExtensionAddItemMap.CREATIVE_ID))},
                {new AdBuilderAdAddItemMap().withCreativeId(ANOTHER_CLIENT_CREATIVE_ID),
                        bothJavaAndPerl(8800, Api5ErrorDetails.CREATIVE_NOT_FOUND)},
                {new AdBuilderAdAddItemMap(),
                        fieldMustBePositiveInteger(capitalize(VideoExtensionUpdateItemMap.CREATIVE_ID))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void addCampaign(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);

    }

    @Test
    public void addMobileAppAdBuilderAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withMobileAppAdBuilderAd(
                                        new MobileAppAdBuilderAdAddMap()
                                                .defaultMobileAppAdBuilderAd(creative))
                                .withAdGroupId(adGroupId)),
                expectedResult
        );
    }
}



