package ru.yandex.autotests.direct.api.ads.add.mobileappadbuilderad;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Попытка добавления ГО, создаваемого на основе креатива, в группу не подходящую по типу")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
public class AddMobileAppAdBuilderAdToIncompatibleAdGroupTest {

    private static final String LOGIN = AdsLogins.CLIENT25;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void addMobileAppAdBuilderAdToTextAdGroup() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN).perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(LOGIN).getClientID()));
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppAdBuilderAd(
                                new MobileAppAdBuilderAdAddMap().defaultMobileAppAdBuilderAd(creativeId)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP)
                )
        );
    }

    @Test
    public void addMobileAppAdBuilderAdToDynamicTextAdGroup() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        Long creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN).perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(LOGIN).getClientID()));
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppAdBuilderAd(
                                new MobileAppAdBuilderAdAddMap().defaultMobileAppAdBuilderAd(creativeId)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP)
                )
        );
    }

}
