package ru.yandex.autotests.direct.api.ads.add.mobileappadbuilderad;

import java.util.Collection;

import org.glassfish.gmbal.Description;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsHrefValidationHelper;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка валидации поля Href. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
@RunWith(Parameterized.class)
public class AddMobileAppAdBuilderAdUrlValidationNegativeTest {
    private static String CLIENT = AdsLogins.CLIENT39;
    private static Long creativeId;
    private static Long adGroupId;
    private MobileAppAdBuilderAdAddMap mobileAppAdBuilderAdAddMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameter(0)
    public String description;

    @Parameter(1)
    public String trackingUrl;

    @Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Collection<Object[]> data = AdsHrefValidationHelper.getHrefDataForNegativeParameterized();
        data.add(new Object[]{"Создать баннер с неподдерживаемой ссылкой", "http://trackingurl.ru",
                bothJavaAndPerl(5006, Api5ErrorDetailsJava.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED)});
        data.add(new Object[]{"Создать баннер с пустой ссылкой", "",
                bothJavaAndPerl(5005, Api5ErrorDetails.INCORRECT_LINK)});
        data.add(new Object[]{"Создать баннер со ссылкой, состоящей из пробелов", "   ",
                bothJavaAndPerl(5005, Api5ErrorDetails.INCORRECT_LINK)});
        return data;
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(CLIENT).perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(CLIENT).getClientID()));
        api.as(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
    }

    @Before
    public void initMap() {
        mobileAppAdBuilderAdAddMap = new MobileAppAdBuilderAdAddMap()
                .withCreative(creativeId)
                .withTrackingUrl(trackingUrl);
    }

    @Test
    public void addWithTrackingUrl() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withMobileAppAdBuilderAd(mobileAppAdBuilderAdAddMap)
                                .withAdGroupId(adGroupId)),
                expectedResult);
    }

}
