package ru.yandex.autotests.direct.api.ads.add.mobileappadbuilderad;

import java.util.Collection;

import com.yandex.direct.api.v5.ads.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsHrefValidationHelper;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка валидации поля Href. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
@RunWith(Parameterized.class)
public class AddMobileAppAdBuilderAdUrlValidationPositiveTest {
    static String CLIENT = AdsLogins.CLIENT40;
    private static Long adGroupId;
    private static DirectJooqDbSteps dbSteps;
    private static Long creativeId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String href;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return AdsHrefValidationHelper.getHrefDataForPositiveParameterized();
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(CLIENT).perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(CLIENT).getClientID()));
        api.as(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
    }

    @Test
    public void addWithTrackingUrl() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppAdBuilderAd(
                                new MobileAppAdBuilderAdAddMap().defaultMobileAppAdBuilderAd(creativeId)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.success()
        );
        Long id = response.getAddResults().get(0).getId();

        assertThat("трекинговая ссылка сохранилась верно",
                dbSteps.bannersSteps().getBanner(id).getHref(),
                equalTo(MobileAppAdBuilderAdAddMap.DEFAULT_TRACKING_URL));
    }

    @Test
    public void addWithoutTrackingUrl() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppAdBuilderAd(
                                new MobileAppAdBuilderAdAddMap().withCreative(creativeId)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.success()
        );
        Long id = response.getAddResults().get(0).getId();

        assertThat("трекинговая ссылка сохранилась верно",
                dbSteps.bannersSteps().getBanner(id).getHref(),
                equalTo(null));
    }
}
