package ru.yandex.autotests.direct.api.ads.add.mobileappcpcvideoadbuilderad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdBuilderAdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppCpcVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.VideoExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.VideoExtensionUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldMustBePositiveInteger;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка работы поля CreativeId")
@Issue("https://st.yandex-team.ru/DIRECT-132279")
@RunWith(Parameterized.class)
public class AddMobileAppCpcVideoAdBuilderAdCreativeValidationNegativeTest {
    private static final String LOGIN = AdsLogins.CLIENT;
    private static final Long NEGATIVE_ID = -1L;
    private static final Long ZERO_ID = 0L;
    private static final Long ANOTHER_CLIENT_CREATIVE_ID = 123L;
    private Long adGroupId;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public AdBuilderAdAddItemMap creative;

    @Parameterized.Parameter(1)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        Object[][] data = new Object[][]{
                {new AdBuilderAdAddItemMap().withCreativeId(NEGATIVE_ID),
                        fieldMustBePositiveInteger(capitalize(VideoExtensionAddItemMap.CREATIVE_ID))},

                {new AdBuilderAdAddItemMap().withCreativeId(ZERO_ID),
                        fieldMustBePositiveInteger(capitalize(VideoExtensionAddItemMap.CREATIVE_ID))},

                {new AdBuilderAdAddItemMap().withCreativeId(ANOTHER_CLIENT_CREATIVE_ID),
                        bothJavaAndPerl(8800, Api5ErrorDetails.CPC_VIDEO_NOT_FOUND)},

                {new AdBuilderAdAddItemMap(),
                        fieldMustBePositiveInteger(capitalize(VideoExtensionUpdateItemMap.CREATIVE_ID))},
        };
        return Arrays.asList(data);
    }

    @Before
    public void addCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
    }

    @Test
    public void addAdBuilderAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withMobileAppCpcVideoAdBuilderAd(
                                        new MobileAppCpcVideoAdBuilderAdAddMap()
                                                .defaultMobileAppCpcVideoAdBuilderAd(creative))
                                .withAdGroupId(adGroupId)),
                expectedResult
        );
    }
}
