package ru.yandex.autotests.direct.api.ads.add.mobileappcpcvideoadbuilderad;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppCpcVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка работы поля CreativeId")
@Issue("https://st.yandex-team.ru/DIRECT-132279")
@RunWith(Parameterized.class)
public class AddMobileAppCpcVideoAdBuilderAdCreativeValidationPositiveTest {
    private static final String LOGIN = AdsLogins.CLIENT;
    private static final String REP_LOGIN = AdsLogins.CLIENT_REP;
    private Long adGroupId;
    private Long creativeId;

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection<Object[]> testData() {
        Object[][] data = new Object[][]{
                {LOGIN},
                {REP_LOGIN}
        };
        return Arrays.asList(data);
    }

    @Before
    public void addCamp() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN).perfCreativesSteps().saveDefaultCpcVideoCreative(
                        Long.parseLong(User.get(LOGIN).getClientID()));
        api.as(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);

    }

    @Test
    public void addAdBuilderAd() {
        Long adId = api.as(loginForAuthorization).userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withMobileAppCpcVideoAdBuilderAd(
                                new MobileAppCpcVideoAdBuilderAdAddMap()
                                        .defaultMobileAppCpcVideoAdBuilderAd(creativeId))
                        .withAdGroupId(adGroupId)
        );
        List<Long> creativeIds = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(loginForAuthorization)
                .bannersPerformanceSteps()
                .findCreativeIds(adId);
        assumeThat("получена одна запись", creativeIds, hasSize(1));
        assertThat("получена ожидаемая связка из banner_performance", creativeIds.get(0),
                equalTo(creativeId));
    }
}
