package ru.yandex.autotests.direct.api.ads.add.mobileappcpcvideoadbuilderad;

import com.yandex.direct.api.v5.ads.AddResponse;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppCpcVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка сохранения TrackingUrl в кликовом видеообъявлении РМП")
@Issue("https://st.yandex-team.ru/DIRECT-132279")
public class AddMobileAppCpcVideoAdBuilderAdTrackingUrlTest {
    private static final String CLIENT = AdsLogins.CLIENT34;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;
    private static Long creativeId;
    private static DirectJooqDbSteps dbSteps;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(CLIENT).perfCreativesSteps().saveDefaultCpcVideoCreative(
                        Long.parseLong(User.get(CLIENT).getClientID()));

        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
    }

    @Test
    public void addWithTrackingUrl() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppCpcVideoAdBuilderAd(
                                new MobileAppCpcVideoAdBuilderAdAddMap()
                                        .defaultMobileAppCpcVideoAdBuilderAd(creativeId)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.success()
        );
        Long id = response.getAddResults().get(0).getId();

        Assert.assertThat("трекинговая ссылка сохранилась верно",
                dbSteps.bannersSteps().getBanner(id).getHref(),
                equalTo(MobileAppCpcVideoAdBuilderAdAddMap.DEFAULT_TRACKING_URL));
    }

    @Test
    public void addWithoutTrackingUrl() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppCpcVideoAdBuilderAd(
                                new MobileAppCpcVideoAdBuilderAdAddMap()
                                        .withCreative(creativeId)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.success()
        );
        Long id = response.getAddResults().get(0).getId();

        Assert.assertThat("трекинговая ссылка сохранилась верно",
                dbSteps.bannersSteps().getBanner(id).getHref(),
                Matchers.nullValue());
    }
}
