package ru.yandex.autotests.direct.api.ads.add.mobileappcpcvideoadbuilderad;

import java.util.Collection;

import org.glassfish.gmbal.Description;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsHrefValidationHelper;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppCpcVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.expect;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка валидации поля TrackingUrl. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-132279")
@RunWith(Parameterized.class)
public class AddMobileAppCpcVideoAdBuilderAdTrackingUrlValidationNegativeTest {
    private static final String CLIENT = AdsLogins.CLIENT39;
    private static Long creativeId;
    private static Long adGroupId;
    private MobileAppCpcVideoAdBuilderAdAddMap mobileAppCpcVideoAdBuilderAdAddMap;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public String trackingUrl;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Collection<Object[]> data = AdsHrefValidationHelper.getHrefDataForNegativeParameterized();

        data.add(new Object[]{"Создать баннер с пустой ссылкой", "",
                expect(5003, Api5ErrorDetails.EMPTY_HREF, Api5ErrorDetailsJava.EMPTY_HREF)});

        data.add(new Object[]{"Создать баннер со ссылкой, состоящей из пробелов", "   ",
                expect(5003, Api5ErrorDetails.EMPTY_HREF, Api5ErrorDetailsJava.EMPTY_HREF)});

        data.add(new Object[]{"Создать баннер с обычной ссылкой, не трекинговой", "https://site.ru",
                expect(5006, Api5ErrorDetails.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED,
                        Api5ErrorDetailsJava.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED)});
        return data;
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(CLIENT).perfCreativesSteps().saveDefaultCpcVideoCreative(
                        Long.parseLong(User.get(CLIENT).getClientID()));
        api.as(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
    }

    @Before
    public void initMap() {
        mobileAppCpcVideoAdBuilderAdAddMap = new MobileAppCpcVideoAdBuilderAdAddMap()
                .withCreative(creativeId)
                .withTrackingUrl(trackingUrl);
    }

    @Test
    public void addWithTrackingUrl() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withMobileAppCpcVideoAdBuilderAd(mobileAppCpcVideoAdBuilderAdAddMap)
                                .withAdGroupId(adGroupId)),
                expectedResult);
    }

}

