package ru.yandex.autotests.direct.api.ads.add.mobileappimagead;

import com.yandex.direct.api.v5.ads.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 06.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка доступа к AdImageHash в графических объявлениях РМП")
@Issue("https://st.yandex-team.ru/DIRECT-54754")
@Tag(TagDictionary.TRUNK)
public class AddMobileAppImageAdAdImageHashTest {
    private static String client = AdsLogins.CLIENT30;
    private static String otherClient = AdsLogins.CLIENT31;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adGroupId;
    private static String adImageHash;
    private static DirectJooqDbSteps dbSteps;

    @BeforeClass
    public static void initTest() {
        api.as(client).userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(1);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(client);
    }

    @Test
    public void addWithOwnAdImageHash() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withMobileAppImageAd(new MobileAppImageAdAddMap().withAdImageHash(adImageHash))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());
        }

    @Test
    public void addWithNotOwnAdImageHash() {
        String notOwnAdImageHash = api.as(otherClient).userSteps.imagesStepsV5().addImageAdAdImage(2);

        api.as(client).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppImageAd(
                                new MobileAppImageAdAddMap().defaultMobileAppImageAd(notOwnAdImageHash)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)
                )
        );
    }

    @Test
    public void addWithNonImageAdAdImageHash() {
        String regularAdImageHash = api.userSteps.imagesStepsV5().addDefaultRegularAdImage();
        String wideAdImageHash = api.userSteps.imagesStepsV5().addDefaultWideAdImage();

        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppImageAd(
                                new MobileAppImageAdAddMap().defaultMobileAppImageAd(regularAdImageHash)
                        ).withAdGroupId(adGroupId),
                        new AdAddItemMap().withMobileAppImageAd(
                                new MobileAppImageAdAddMap().defaultMobileAppImageAd(wideAdImageHash)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.INVALID_AD_IMAGE_TYPE_FOR_THIS_BANNER)
                ),
                ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.INVALID_AD_IMAGE_TYPE_FOR_THIS_BANNER)
                )

        );
    }

    @Test
    public void addWithNonExistentAdImageHash() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppImageAd(
                                new MobileAppImageAdAddMap().defaultMobileAppImageAd("11111111")
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)
                )
        );
    }

    @Test
    public void addWithDeletedAdImageHash() {
        String deletedAdImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(3);
        api.userSteps.imagesStepsV5().adImagesDelete(deletedAdImageHash);

        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppImageAd(
                                new MobileAppImageAdAddMap().defaultMobileAppImageAd(deletedAdImageHash)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)
                )
        );
    }

    @Test
    public void addWithEmptyAdImageHash() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppImageAd(
                                new MobileAppImageAdAddMap().defaultMobileAppImageAd("")
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)
                )
        );
    }

    @Test
    public void addWithSpaceInAdImageHash() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppImageAd(
                                new MobileAppImageAdAddMap().defaultMobileAppImageAd(" ")
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)
                )
        );
    }

}
