package ru.yandex.autotests.direct.api.ads.add.mobileappimagead;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ImagesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 22.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка сохранения в БД графических объявлений РМП")
@Issue("https://st.yandex-team.ru/DIRECT-54754")
@Tag(TagDictionary.TRUNK)
public class AddMobileAppImageAdCheckDbTest {

    private static String client = AdsLogins.CLIENT46;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adGroupId;
    private static Long id;
    private static String adImageHash;
    private static DirectJooqDbSteps dbSteps;

    @BeforeClass
    public static void initTest() {
        api.as(client).userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(6);
        id = api.userSteps.adsSteps().addDefaultMobileAppImageAd(adGroupId, adImageHash);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(client);
    }

    @Test
    public void checkTypeInBanners() {
        assertThat("объявление в БД создано с правильным типом",
                dbSteps.bannersSteps().getBanner(id).getBannerType(),
                equalTo(BannersBannerType.image_ad));
    }

    @Test
    public void checkImages() {
        ImagesRecord imagesRecord = dbSteps.imagesSteps().getImagesRecords(campaignId, adGroupId, id);
        ImagesRecord expectedImagesRecord = new ImagesRecord()
                .setBid(id)
                .setCid(campaignId)
                .setPid(adGroupId)
                .setImageHash(adImageHash)
                .setStatusmoderate(ImagesStatusmoderate.New);
        assertThat("к объявлению в БД привязано правильное изображение",
                imagesRecord.intoMap(), beanDiffer(expectedImagesRecord.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
