package ru.yandex.autotests.direct.api.ads.add.mobileappimagead;

import com.yandex.direct.api.v5.ads.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * Created by gerdler on 07.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка сохранения TrackingUrl в графических баннерах РМП")
@Issue("https://st.yandex-team.ru/DIRECT-54754")
public class AddMobileAppImageAdTrackingUrlTest {
    private static String client = AdsLogins.CLIENT34;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;
    private static String adImageHash;
    private static DirectJooqDbSteps dbSteps;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adImageHash = api.userSteps.imagesStepsV5().addDefaultImageAdAdImage();
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(client);
    }

    @Test
    public void addWithTrackingUrl() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppImageAd(
                                new MobileAppImageAdAddMap().defaultMobileAppImageAd(adImageHash)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.success()
        );
        Long id = response.getAddResults().get(0).getId();

        assertThat("трекинговая ссылка сохранилась верно", dbSteps.bannersSteps().getBanner(id).getHref(), equalTo(MobileAppImageAdAddMap.DEFAULT_TRACKING_URL));
    }

    @Test
    public void addWithoutTrackingUrl() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppImageAd(
                                new MobileAppImageAdAddMap().withAdImageHash(adImageHash)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.success()
        );
        Long id = response.getAddResults().get(0).getId();

        assertThat("трекинговая ссылка сохранилась верно", dbSteps.bannersSteps().getBanner(id).getHref(), equalTo(null));
    }
}
