package ru.yandex.autotests.direct.api.ads.add.mobileappimagead;

import java.util.Collection;

import org.glassfish.gmbal.Description;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsHrefValidationHelper;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.expect;

/**
 * Created by gerdler on 11.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка валидации поля TrackingUrl. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-54754")
@RunWith(Parameterized.class)
public class AddMobileAppImageAdTrackingUrlValidationNegativeTest {
    private static String client = AdsLogins.CLIENT15;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;
    private static String adImageHash;
    private MobileAppImageAdAddMap mobileAppImageAdAddMap;

    @Parameter(0)
    public String description;

    @Parameter(1)
    public String trackingUrl;

    @Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Collection<Object[]> data = AdsHrefValidationHelper.getHrefDataForNegativeParameterized();
        data.add(new Object[]{"Создать баннер с неподдерживаемой ссылкой", "http://trackingurl.ru",
                expect(5006,
                        Api5ErrorDetails.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED,
                        Api5ErrorDetailsJava.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED)});
        data.add(new Object[]{"Создать баннер с пустой ссылкой", "",
                bothJavaAndPerl(5005, Api5ErrorDetails.INCORRECT_LINK)});
        data.add(new Object[]{"Создать баннер со ссылкой, состоящей из пробелов", "   ",
                bothJavaAndPerl(5005, Api5ErrorDetails.INCORRECT_LINK)});
        return data;
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adImageHash = api.userSteps.imagesStepsV5().addDefaultImageAdAdImage();
    }

    @Before
    public void initMap() {
        mobileAppImageAdAddMap = new MobileAppImageAdAddMap()
                .withAdImageHash(adImageHash)
                .withTrackingUrl(trackingUrl);
    }

    @Test
    public void addWithTrackingUrl() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withMobileAppImageAd(mobileAppImageAdAddMap)
                                .withAdGroupId(adGroupId)),
                expectedResult);
    }

}
