package ru.yandex.autotests.direct.api.ads.add.textad;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldMustBePositiveInteger;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 14.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка доступа к SitelinkSetId для текстовых объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
public class AccessToSitelinkSetIdTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    static TextAdAddMap textAdAddMap;
    private Long sitelinkSetId;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        textAdAddMap = new TextAdAddMap().defaultTextAd();
    }

    @Before
    public void createSitelink() {
        api.as(AdsLogins.CLIENT);
        sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
    }

    @Test
    public void addWithMySitelinkSetId() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(textAdAddMap.withSitelinkSetId(sitelinkSetId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());
        Long id = response.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(id))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.SITELINK_SET_ID));
        assertThat("SitelinkSetId сохранился верно", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(id)
                        .withTextAd(new TextAdGetMap().withSitelinkSetId(sitelinkSetId)).getBean())));
    }

    @Test
    public void addWithNotMySitelinkSetId() {
        //DIRECT-41105
        api.as(AdsLogins.CLIENT_ELSE);
        Long notMySitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        api.as(AdsLogins.CLIENT);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(textAdAddMap.withSitelinkSetId(notMySitelinkSetId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.SITELINKS_SET_NOT_FOUND)));
    }

    @Test
    public void addWithNonExistentSitelinkSetId() {
        //DIRECT-41106
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(textAdAddMap.withSitelinkSetId(sitelinkSetId + 100000))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.SITELINKS_SET_NOT_FOUND)));
    }

    @Test
    public void addWithDeletedSitelinkSetId() {
        //DIRECT-41106
        api.userSteps.sitelinksSteps().delete(sitelinkSetId);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(textAdAddMap.withSitelinkSetId(sitelinkSetId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.SITELINKS_SET_NOT_FOUND)));
    }
}
