package ru.yandex.autotests.direct.api.ads.add.textad;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.ads.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersAdditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static ru.yandex.autotests.direct.db.utils.JooqRecordListDifferMatcher.recordsDiffer;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 10.03.16.
 * https://st.yandex-team.ru/TESTIRT-8642
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка привязки в базе уточнений к текстовым объявлениям")
@Issue("https://st.yandex-team.ru/DIRECT-50726")
@Tag(TagDictionary.TRUNK)
public class AdAdsWithAdExtensionsAndCheckDBTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adGroupId;
    private static TextAdAddMap textAdAddMap;
    private static Long calloutId;
    private static Long calloutIdElse;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        textAdAddMap = new TextAdAddMap().defaultTextAd();
        calloutId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        calloutIdElse = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
    }

    @Test
    public void addOneAdWithOneCallout() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(textAdAddMap.withAdExtensionIds(calloutId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());
        Long bid = response.getAddResults().get(0).getId();

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(bid);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(bid, calloutId, BannersAdditionsAdditionsType.callout, (short) 1);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions)));
    }

    @Test
    public void addOneAdWithTwoCallouts() {
        //DIRECT-51937
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(textAdAddMap.withAdExtensionIds(calloutId, calloutIdElse))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());
        Long bid = response.getAddResults().get(0).getId();

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(bid);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(bid, calloutId, BannersAdditionsAdditionsType.callout, (short) 1);
        BannersAdditionsRecord expectedBannersAdditionsElse =
                new BannersAdditionsRecord(bid, calloutIdElse, BannersAdditionsAdditionsType.callout, (short) 2);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions, expectedBannersAdditionsElse)));
    }

    @Test
    public void addTwoAdsWithTwoDifferentCallouts() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .defaultTextAd()
                                                .withAdExtensionIds(calloutId))
                                        .withAdGroupId(adGroupId),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .defaultTextAd()
                                                .withAdExtensionIds(calloutIdElse))
                                        .withAdGroupId(adGroupId)),
                ExpectedResult.success(), ExpectedResult.success());
        Long bid = response.getAddResults().get(0).getId();
        Long bidElse = response.getAddResults().get(1).getId();

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(bid);
        List<BannersAdditionsRecord> bannersAdditionsElse =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(bidElse);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(bid, calloutId, BannersAdditionsAdditionsType.callout, (short) 1);
        BannersAdditionsRecord expectedBannersAdditionsElse =
                new BannersAdditionsRecord(bidElse, calloutIdElse, BannersAdditionsAdditionsType.callout, (short) 1);

        assumeThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions)));
        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditionsElse, recordsDiffer(Arrays.asList(expectedBannersAdditionsElse)));
    }

    @Test
    public void addTwoAdsWithTwoSameCallouts() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .defaultTextAd()
                                                .withAdExtensionIds(calloutId))
                                        .withAdGroupId(adGroupId),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .defaultTextAd()
                                                .withAdExtensionIds(calloutId))
                                        .withAdGroupId(adGroupId)),
                ExpectedResult.success(), ExpectedResult.success());
        Long bid = response.getAddResults().get(0).getId();
        Long bidElse = response.getAddResults().get(1).getId();

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(bid);
        List<BannersAdditionsRecord> bannersAdditionsElse =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(bidElse);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(bid, calloutId, BannersAdditionsAdditionsType.callout, (short) 1);
        BannersAdditionsRecord expectedBannersAdditionsElse =
                new BannersAdditionsRecord(bidElse, calloutId, BannersAdditionsAdditionsType.callout, (short) 1);

        assumeThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions)));
        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditionsElse, recordsDiffer(Arrays.asList(expectedBannersAdditionsElse)));
    }

    @Test
    public void addTwoAdsWithOneCalloutInFirstAd() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .defaultTextAd()
                                                .withAdExtensionIds(calloutId))
                                        .withAdGroupId(adGroupId),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .defaultTextAd())
                                        .withAdGroupId(adGroupId)),
                ExpectedResult.success(), ExpectedResult.success());
        Long bid = response.getAddResults().get(0).getId();

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(bid);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(bid, calloutId, BannersAdditionsAdditionsType.callout, (short) 1);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions)));
    }

    @Test
    public void addTwoAdsWithOneCalloutInSecondAd() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .defaultTextAd())
                                        .withAdGroupId(adGroupId),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .defaultTextAd()
                                                .withAdExtensionIds(calloutId))
                                        .withAdGroupId(adGroupId)),
                ExpectedResult.success(), ExpectedResult.success());
        Long bid = response.getAddResults().get(1).getId();

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(bid);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(bid, calloutId, BannersAdditionsAdditionsType.callout, (short) 1);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions)));
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-53172")
    @Description("Сохранение в разных баннерах одинакового набора уточнений, но с разным порядком")
    public void addTwoAdsWithSameCalloutsWithDifferentSequences() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .defaultTextAd()
                                                .withAdExtensionIds(calloutId, calloutIdElse))
                                        .withAdGroupId(adGroupId),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .defaultTextAd()
                                                .withAdExtensionIds(calloutIdElse, calloutId))
                                        .withAdGroupId(adGroupId)),
                ExpectedResult.success(), ExpectedResult.success());
        Long bid = response.getAddResults().get(0).getId();
        Long bidElse = response.getAddResults().get(1).getId();

        List<BannersAdditionsRecord> bannersAdditionsFirst =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(bid);
        List<BannersAdditionsRecord> bannersAdditionsSecond =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(bidElse);

        BannersAdditionsRecord expectedBannersAdditionsFirst =
                new BannersAdditionsRecord(bid, calloutId, BannersAdditionsAdditionsType.callout, (short) 1);
        BannersAdditionsRecord expectedBannersAdditionsFirstElse =
                new BannersAdditionsRecord(bid, calloutIdElse, BannersAdditionsAdditionsType.callout, (short) 2);
        BannersAdditionsRecord expectedBannersAdditionsSecond =
                new BannersAdditionsRecord(bidElse, calloutId, BannersAdditionsAdditionsType.callout, (short) 2);
        BannersAdditionsRecord expectedBannersAdditionsSecondElse =
                new BannersAdditionsRecord(bidElse, calloutIdElse, BannersAdditionsAdditionsType.callout, (short) 1);

        assumeThat("дополнения правильно привязались к объявлению",
                bannersAdditionsFirst, recordsDiffer(Arrays.asList(expectedBannersAdditionsFirst, expectedBannersAdditionsFirstElse)));
        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditionsSecond, recordsDiffer(Arrays.asList(expectedBannersAdditionsSecond, expectedBannersAdditionsSecondElse)));
    }
}
