package ru.yandex.autotests.direct.api.ads.add.textad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.PriceCurrencyEnum;
import com.yandex.direct.api.v5.ads.PriceQualifierEnum;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.ads.TextAdPriceExtensionFieldEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.PriceExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.PriceExtensionGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.yandex.direct.api.v5.ads.PriceCurrencyEnum.RUB;
import static com.yandex.direct.api.v5.ads.PriceQualifierEnum.FROM;
import static com.yandex.direct.api.v5.ads.PriceQualifierEnum.NONE;
import static java.util.Collections.singletonList;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка работы поля BannerPrice: позитивные кейсы")
@Issue("https://st.yandex-team.ru/DIRECT-89499")
@RunWith(Parameterized.class)
public class AddBannerPricePositiveTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    static Long campaignId;
    static Long adGroupId;

    private static final Long ONE = 1000000L;
    private static final Long TEN = 10000000L;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;
    @Parameterized.Parameter(1)
    public PriceExtensionAddItemMap price;

    TextAdAddMap textAdAddMap;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(
                new Object[]{"Заполненная цена", price(ONE, TEN, RUB, FROM)},
                new Object[]{"Цена с префиксом NONE", price(ONE, TEN, RUB, NONE)},
                new Object[]{"Цена без старой цены", price(ONE, null, RUB, FROM)});
    }

    private static PriceExtensionAddItemMap price(Long price, Long oldPrice, PriceCurrencyEnum currency,
                                                  PriceQualifierEnum prefix)
    {
        return new PriceExtensionAddItemMap()
                .withPrice(price)
                .withOldPrice(oldPrice)
                .withPriceCurrency(currency)
                .withPriceQualifier(prefix);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Before
    public void initMap() {
        textAdAddMap = new TextAdAddMap()
                .withText(TextAdAddMap.DEFAULT_TEXT)
                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                .withHref(TextAdAddMap.DEFAULT_HREF)
                .withMobile(YesNoEnum.NO)
                .withPriceExtension(price);
    }

    @Test
    public void addWithBannerPriceAndCheckSave() {
        //DIRECT-41067
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withTextAd(textAdAddMap)
                        .withAdGroupId(adGroupId)), ExpectedResult.success());
        Long id = response.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(id))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.TEXT)
                .withTextAdPriceExtensionFieldNames(TextAdPriceExtensionFieldEnum.values()));

        assertThat("цена на товар на баннере сохранась верно", getResponse.getAds(), beanDifferV5(
                singletonList((AdGetItem) new AdGetItemMap().withId(id).withTextAd(
                        new TextAdGetMap()
                                .withText(TextAdAddMap.DEFAULT_TEXT)
                                .withPriceExtension(convertAddToGet(price)))
                        .getBean())));
    }

    private PriceExtensionGetItemMap convertAddToGet(PriceExtensionAddItemMap add) {
        return new PriceExtensionGetItemMap()
                .withPrice((Long) add.get(PriceExtensionAddItemMap.PRICE))
                .withOldPrice((Long) add.get(PriceExtensionAddItemMap.OLD_PRICE))
                .withPriceCurrency((PriceCurrencyEnum) add.get(PriceExtensionAddItemMap.PRICE_CURRENCY))
                .withPriceQualifier((PriceQualifierEnum) add.get(PriceExtensionAddItemMap.PRICE_QUALIFIER));
    }
}
