package ru.yandex.autotests.direct.api.ads.add.textad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 09.04.16.
 * https://st.yandex-team.ru/TESTIRT-8931
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка соответствия языка в DisplayUrlPath и геотаргетинга группы. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-52434")
@RunWith(Parameterized.class)
public class AddDisplayUrlPathGeoMatchingPositiveTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    Long adGroupId;
    TextAdAddMap textAdAddMap;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String path;

    @Parameterized.Parameter(2)
    public Long regionId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Добавить баннер с украинским урлом в группу с таргетингом на Украину",
                        "горілка", RegionIDValues.UKRAINE.getId().longValue()},
                {"Добавить баннер с турецким урлом в группу с таргетингом на Турцию",
                        "türkiye", RegionIDValues.TURKEY.getId().longValue()},
                {"Добавить баннер с казахским урлом в группу с таргетингом на Казахстан",
                        "арақ", RegionIDValues.KAZAKHSTAN.getId().longValue()},
                //after https://st.yandex-team.ru/DIRECT-53906
                {"Добавить баннер с украинским урлом в группу с таргетингом на Россию",
                        "горілка", RegionIDValues.RUSSIA.getId().longValue()},
                {"Добавить баннер с турецким урлом в группу с таргетингом на Россию",
                        "türkiye", RegionIDValues.RUSSIA.getId().longValue()},
                {"Добавить баннер с казахским урлом в группу с таргетингом на Россию",
                        "арақ", RegionIDValues.RUSSIA.getId().longValue()}
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
    }

    @Before
    public void createGroup() {
        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .withCampaignId(campaignId)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME)
                        .withRegionIds(regionId));
        textAdAddMap = new TextAdAddMap()
                .defaultTextAd()
                .withDisplayUrlPath(path);
    }

    @Test
    public void addWithPathAndCheckSave() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withTextAd(textAdAddMap)
                        .withAdGroupId(adGroupId)), ExpectedResult.success());
        Long id = response.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(id))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.DISPLAY_URL_PATH));
        assertThat("зеленый урл баннера сохранился верно", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(id)
                        .withTextAd(new TextAdGetMap().withDisplayUrlPath(path)).getBean())));
    }
}
