package ru.yandex.autotests.direct.api.ads.add.textad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldLengthExceeded;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.expect;

/**
 * Created by ginger on 07.04.16.
 * https://st.yandex-team.ru/TESTIRT-8931
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка валидации поля DisplayUrlPath. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-52434")
@RunWith(Parameterized.class)
public class AddDisplayUrlPathValidationNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    TextAdAddMap textAdAddMap;

    @Parameter(0)
    public String description;

    @Parameter(1)
    public String path;

    @Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        String pathWithSpecificSymbol = "hello!world";
        String emptyString = "";
        String stringWithSpace = " ";
        String doubleDash = "--";
        String doubleSlash = "//";
        String greaterThanMaxLengthPath = randomAlphabetic(TextAdAddMap.MAX_DISPLAY_URL_PATH + 1);
        String greaterThanMaxLengthPathWithSpecific = randomAlphabetic(TextAdAddMap.MAX_DISPLAY_URL_PATH) + "#";

        return Arrays.asList(new Object[][]{
                {"Создать баннер со ссылкой, содержащей специфичный символ", pathWithSpecificSymbol,
                        bothJavaAndPerl(5002, Api5ErrorDetails.INVALID_SYMBOL_IN_DISPLAY_URL_PATH, "!")},
                {"Создать баннер со ссылкой, содержащей пустую строку", emptyString,
                        expect(5004,
                                Api5ErrorDetails.FIELD_SHOULD_NOT_BE_EMPTY,
                                Api5ErrorDetailsJava.EMPTY_VALUE,
                                capitalize(TextAdAddMap.DISPLAY_URL_PATH))},
                {"Создать баннер со ссылкой, содержащей пробел", stringWithSpace,
                        bothJavaAndPerl(5002, Api5ErrorDetails.INVALID_SYMBOL_IN_DISPLAY_URL_PATH, " ")},
                {"Обновить баннер со ссылкой длиной большей, чем " + TextAdAddMap.MAX_DOMAIN_LENGTH + " и с #",
                        greaterThanMaxLengthPathWithSpecific,
                        fieldLengthExceeded(capitalize(TextAdAddMap.DISPLAY_URL_PATH),
                                TextAdAddMap.MAX_DISPLAY_URL_PATH)},
                {"Создать баннер со ссылкой длиной большей, чем " + TextAdAddMap.MAX_DOMAIN_LENGTH,
                        greaterThanMaxLengthPath,
                        fieldLengthExceeded(capitalize(TextAdAddMap.DISPLAY_URL_PATH),
                                TextAdAddMap.MAX_DISPLAY_URL_PATH)},
                {"Создать баннер со ссылкой, содержащей двойное тире", doubleDash,
                        expect(5004, Api5ErrorDetails.SPECIFIC_SYMBOLS_MUST_NOT_BE_REPEATED,
                                Api5ErrorDetailsJava.SPECIAL_CHARS_MUST_NOT_BE_REPEATED,
                                capitalize(TextAdAddMap.DISPLAY_URL_PATH))},
                {"Создать баннер со ссылкой, содержащей двойной слэш", doubleSlash,
                        expect(5004, Api5ErrorDetails.SPECIFIC_SYMBOLS_MUST_NOT_BE_REPEATED,
                                Api5ErrorDetailsJava.SPECIAL_CHARS_MUST_NOT_BE_REPEATED,
                                capitalize(TextAdAddMap.DISPLAY_URL_PATH))}
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Before
    public void initMap() {
        textAdAddMap = new TextAdAddMap()
                .withText(TextAdAddMap.DEFAULT_TEXT)
                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                .withHref(TextAdAddMap.DEFAULT_HREF)
                .withDisplayUrlPath(path)
                .withMobile(YesNoEnum.NO);
    }

    @Test
    public void addWithDisplayUrlPath() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(textAdAddMap)
                                .withAdGroupId(adGroupId)),
                expectedResult);
    }
}
