package ru.yandex.autotests.direct.api.ads.add.textad;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 07.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Создание мобильных баннеров")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
@Tag(TagDictionary.TRUNK)
public class AddMobileAdsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId1;
    static Long adGroupId2;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void addOneAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withTextAd(new TextAdAddMap().defaultMobileAd())
                        .withAdGroupId(adGroupId1)), ExpectedResult.success());
    }

    @Test
    public void addTwoAdsInOneGroup() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultMobileAd())
                                .withAdGroupId(adGroupId1),
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultMobileAd())
                                .withAdGroupId(adGroupId1)), ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    public void addTwoAdsInTwoGroups() {
        //DIRECT-40823
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultMobileAd())
                                .withAdGroupId(adGroupId1),
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultMobileAd())
                                .withAdGroupId(adGroupId2)), ExpectedResult.success(), ExpectedResult.success());
    }
}
