package ru.yandex.autotests.direct.api.ads.add.textad;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdditionsItemDisclaimersRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 09.12.16.
 * https://st.yandex-team.ru/TESTIRT-10642
 */
@Aqua.Test
@Description("Проверка корректности работы метода при наличии дисклеймера у клиента")
@Issue("https://st.yandex-team.ru/DIRECT-59010")
@Features(AdsFeatures.ADD)
public class AddTextAdDisclaimerTest {
    private static Long disclaimerId;
    private static int shardId;
    private static Long adExtensionId;
    private static Long campaignId;
    private static Long adGroupId;
    private static String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void prepareData() {
        shardId = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        disclaimerId = api.userSteps.getDirectJooqDbSteps().useShard(shardId)
                .bannerAdditionsSteps().saveAdditionsItemDisclaimers(
                        Long.parseLong(User.get(LOGIN).getClientID()),
                        RandomStringUtils.randomAlphanumeric(24));
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8), LOGIN);
    }

    @Test
    public void successAdForClientWithDynamicDisclaimer() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(
                                        new TextAdAddMap().defaultTextAd()
                                            .withAdExtensionIds(adExtensionId))
                                .withAdGroupId(adGroupId)),
                LOGIN,
                ExpectedResult.success());
        AdditionsItemDisclaimersRecord disclaimer = api.userSteps.adExtensionsSteps().getDirectJooqDbSteps().useShard(shardId)
                .bannerAdditionsSteps().getDisclaimer(disclaimerId);
        assertThat("дисклеймер не затерся", disclaimer, notNullValue());
    }

    @Test
    public void tryAdWithDynamicDisclaimerInsteadAdExtension() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(
                                        new TextAdAddMap().defaultTextAd()
                                                .withAdExtensionIds(disclaimerId))
                                .withAdGroupId(adGroupId)),
                LOGIN,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_EXTENSION_NOT_FOUND, disclaimerId)));
    }

    @AfterClass
    public static void deleteDisclaimer(){
        api.userSteps.getDirectJooqDbSteps().useShard(shardId)
                .bannerAdditionsSteps().deleteAdditionsItemDisclaimers(disclaimerId);
    }
}

