package ru.yandex.autotests.direct.api.ads.add.textad;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 22.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка независимоти статуса модерации объявления от статусов других объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
@Tag(TagDictionary.TRUNK)
public class CheckStatusModerateAfterAddTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adGroupId;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void addAdToEmptyCampaign() {
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("Баннер остался черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    public void addAdToCampaignWithSentBanner() {
        //DIRECT-42282
        Long moderatedId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.adsSteps().adsModerate(moderatedId);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(moderatedId);
        assumeThat("Баннер отправился на модерацию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("Баннер отправился на модерацию", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    public void addAdToActiveCampaign() {
        //DIRECT-41384
        Long activeAdId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.campaignFakeSteps().makeCampaignActive(campaignId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannerActive(activeAdId);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(activeAdId);
        assumeThat("Баннер активен", bannerFakeInfo.getStatusModerate(), equalTo(Status.YES));
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("Баннер остался черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }
}
