package ru.yandex.autotests.direct.api.ads.add.textad;

import java.util.Collection;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.directapi.cases.TextGeoMatchingWithCampLangCases;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.enums.CampaignLanguage;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.cases.TextGeoMatchingWithCampLangCases.TextField.TITLE;

/**
 * Created by buhter on 29.12.15.
 * https://st.yandex-team.ru/TESTIRT-8124
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка соответствия языка в Text и геотаргетинга группы с учетом выставления языка на кампанию" +
        ", негативные проверки")
@Issue("https://st.yandex-team.ru/DIRECT-49583")
@RunWith(Parameterized.class)
public class TextTitleGeoMatchingWithCampLangNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    private static Integer shard;
    Long adGroupId;
    TextAdAddMap textAdAddMap;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String text;

    @Parameterized.Parameter(2)
    public CampaignLanguage campLang;

    @Parameterized.Parameter(3)
    public Notification expectedNotification;

    @Parameterized.Parameters(name = "{0} и выставлением языка на кампанию - {2}")
    public static Collection<Object[]> data() {
        return TextGeoMatchingWithCampLangCases.getNegativeCases(TITLE)
                .stream()
                .map(c -> new Object[]{c.description, c.text, c.campLang, c.expectedNotification})
                .collect(Collectors.toList());
    }

    @BeforeClass
    public static void initTest() {
        shard = api.userSteps.clientFakeSteps().getUserShard(AdsLogins.CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
    }

    @Before
    public void createGroup() {
        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .getCampOptionsById(campaignId);
        campOptions.setContentLang(campLang.value());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampOptions(campOptions);

        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .withCampaignId(campaignId)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME)
                        .withRegionIds(RegionIDValues.RUSSIA.getId().longValue()));
        textAdAddMap = new TextAdAddMap()
                .withText(text)
                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                .withHref(TextAdAddMap.DEFAULT_HREF)
                .withMobile(YesNoEnum.NO);
    }

    @Test
    public void addWithText() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withTextAd(textAdAddMap)
                        .withAdGroupId(adGroupId)), ExpectedResult.errors(expectedNotification));
    }
}
