package ru.yandex.autotests.direct.api.ads.add.textadbuilderad;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersPerformanceRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка сохранения в БД ГО, создаваемого на основе креатива")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
@Tag(TagDictionary.TRUNK)
public class AddTextAdBuilderAdCheckDbTest {

    private static String LOGIN = AdsLogins.CLIENT47;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adGroupId;
    private static Long id;
    private static DirectJooqDbSteps dbSteps;
    private static Long creativeId;

    @BeforeClass
    public static void initTest() {
        api.as(LOGIN).userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(LOGIN);
        creativeId = dbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(LOGIN).getClientID()));
        id = api.userSteps.adsSteps().addDefaultTextAdBuilderAd(adGroupId, creativeId);
    }

    @Test
    public void checkTypeInBanners() {
       assertThat("объявление в БД создано с правильным типом",
                dbSteps.bannersSteps().getBanner(id).getBannerType(),
                equalTo(BannersBannerType.image_ad));
    }

    @Test
    public void checkCreativeInDB() {
        BannersPerformanceRecord record =
                dbSteps.bannersPerformanceSteps().getBannersPerformance(campaignId, adGroupId, id);
        BannersPerformanceRecord expectedRecord = new BannersPerformanceRecord()
                .setBid(id)
                .setCid(campaignId)
                .setPid(adGroupId)
                .setCreativeId(creativeId)
                .setStatusmoderate(BannersPerformanceStatusmoderate.New);
        assertThat("к объявлению в БД привязан правильный креатив",
                record.intoMap(), beanDiffer(expectedRecord.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
