package ru.yandex.autotests.direct.api.ads.add.textadbuilderad;

import java.util.Collection;

import org.glassfish.gmbal.Description;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsHrefValidationHelper;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.expect;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка валидации поля Href. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
@RunWith(Parameterized.class)
public class AddTextAdBuilderAdHrefValidationNegativeTest {
    private static String CLIENT = AdsLogins.CLIENT39;
    private static Long creativeId;
    private static Long adGroupId;
    private TextAdBuilderAdAddMap textAdBuilderAdAddMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameter(0)
    public String description;

    @Parameter(1)
    public String href;

    @Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Collection<Object[]> data = AdsHrefValidationHelper.getHrefDataForNegativeParameterized();
        data.add(new Object[]{"Создать баннер с пустой ссылкой", "",
                expect(5003, Api5ErrorDetails.EMPTY_HREF, Api5ErrorDetailsJava.EMPTY_HREF)});
        data.add(new Object[]{"Создать баннер со ссылкой, состоящей из пробелов", "   ",
                expect(5003, Api5ErrorDetails.EMPTY_HREF, Api5ErrorDetailsJava.EMPTY_HREF)});
        return data;
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(CLIENT).perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(CLIENT).getClientID()));
        api.as(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Before
    public void initMap() {
        textAdBuilderAdAddMap = new TextAdBuilderAdAddMap()
                .withCreative(creativeId)
                .withHref(href);
    }

    @Test
    public void addWithHref() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAdBuilderAd(textAdBuilderAdAddMap)
                                .withAdGroupId(adGroupId)),
                expectedResult);
    }

}
