package ru.yandex.autotests.direct.api.ads.add.textimagead;

import java.util.Collection;

import org.glassfish.gmbal.Description;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsHrefValidationHelper;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.expect;

/**
 * Created by gerdler on 11.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка валидации поля Href. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-54754")
@RunWith(Parameterized.class)
public class AddTextImageAdHrefValidationNegativeTest {
    private static String client = AdsLogins.CLIENT39;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;
    private static String adImageHash;
    private TextImageAdAddMap textImageAdAddMap;

    @Parameter(0)
    public String description;

    @Parameter(1)
    public String href;

    @Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Collection<Object[]> data = AdsHrefValidationHelper.getHrefDataForNegativeParameterized();
        data.add(new Object[]{"Создать баннер с пустой ссылкой", "",
                expect(5003, Api5ErrorDetails.EMPTY_HREF, Api5ErrorDetailsJava.EMPTY_HREF)});
        data.add(new Object[]{"Создать баннер со ссылкой, состоящей из пробелов", "   ",
                expect(5003, Api5ErrorDetails.EMPTY_HREF, Api5ErrorDetailsJava.EMPTY_HREF)});
        return data;
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adImageHash = api.userSteps.imagesStepsV5().addDefaultImageAdAdImage();
    }

    @Before
    public void initMap() {
        textImageAdAddMap = new TextImageAdAddMap()
                .withAdImageHash(adImageHash)
                .withHref(href);
    }

    @Test
    public void addWithHref() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextImageAd(textImageAdAddMap)
                                .withAdGroupId(adGroupId)),
                expectedResult);
    }

}
