package ru.yandex.autotests.direct.api.ads.add.textimagead;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 11.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка создания текстового графического баннера под разными ролями")
@Issue("https://st.yandex-team.ru/DIRECT-54754")
@RunWith(Parameterized.class)
public class AddTextImageAdRolesTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String apiUserLogin;

    @Parameterized.Parameter(2)
    public String login;

    @Parameterized.Parameter(3)
    public String loginToCreateGroup;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Добавление объявления от имени агенства для субклиента", AdsLogins.AGENCY, AdsLogins.SUBCLIENT_SHARD2,
                        AdsLogins.AGENCY},
                {"Добавление объявления от имени представителя агенства для субклиента", AdsLogins.AGENCY_REP, AdsLogins.SUBCLIENT_SHARD2,
                        AdsLogins.AGENCY_REP}
        });
    }

    private Long adGroupId;
    private String adImageHash;

    @Before
    public void createAd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
        api.as(loginToCreateGroup);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, login);
        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(login, 2);
    }

    @Test
    public void requestUsingLogin() {
        api.as(apiUserLogin);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextImageAd(new TextImageAdAddMap()
                        .defaultTextImageAd(adImageHash))), login, ExpectedResult.success());
    }
}
