package ru.yandex.autotests.direct.api.ads.add.textimagead;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 05.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Попытка добавления графического текстового объявления не в текстовую группу")
@Issue("https://st.yandex-team.ru/DIRECT-54754")
public class AddTextImageAdToIncompatibleAdGroupTest {
    private static String client = AdsLogins.CLIENT25;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.as(client).userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void addImageAdToMobileAppAdGroup() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        String adImageHash = api.userSteps.imagesStepsV5().addDefaultImageAdAdImage();

        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withTextImageAd(
                                new TextImageAdAddMap().defaultTextImageAd(adImageHash)
                        ).withAdGroupId(adGroupId)
                ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(
                                new Notification(6000, Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP),
                                new Notification(5006, Api5ErrorDetailsJava.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED)))
                .perl(ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP))));
    }

    @Test
    public void addImageAdToDynamicTextAdGroup() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        String adImageHash = api.userSteps.imagesStepsV5().addDefaultImageAdAdImage();

        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withTextImageAd(
                                new TextImageAdAddMap().defaultTextImageAd(adImageHash)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP)
                )
        );
    }

}
