package ru.yandex.autotests.direct.api.ads.archive;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.ArchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 16.04.15.
 * https://st.yandex-team.ru/TESTIRT-5211
 */
@Aqua.Test
@Features(AdsFeatures.ARCHIVE)
@Description("Запросы на архивирование объявления по протоколу SOAP")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
public class AdsArchiveSOAPTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.SOAP).version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String ARCHIVE_REQUEST = "ArchiveRequest";
    static Long adId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adId);
    }

    @Test
    @Description("Валидный запрос на архивирование объявления")
    public void successArchiveTest() {
        api.userSteps.adsSteps()
                .shouldGetResultOnArchive(new IdsCriteriaMap().withIds(adId), ExpectedResult.success());
    }

    @Test
    @Description("Пустой запрос на архивирование объявления")
    public void emptyRequest() {
        api.userSteps.adsSteps().expectErrorOnAdsArchive(new ArchiveRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(SuspendRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Пустое поле SelectionCriteria в запросе на архивирование объявления")
    @Issue("DIRECT-88268")
    public void emptySelectionCriteria() {
        api.userSteps.adsSteps().expectErrorOnAdsArchive(
                new ArchiveRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(SuspendRequestMap.SELECTION_CRITERIA)));
    }
}
