package ru.yandex.autotests.direct.api.ads.archive;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.ArchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdsFeatures.ARCHIVE)
@Issue("https://st.yandex-team.ru/DIRECT-83722")
public class ArchiveCpmBannerAdTest {

    private static final String LOGIN = AdsLogins.CLIENT;
    private static Long cpmBannerAdId;
    private static Long cpmVideoAdId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createTestData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long creativeId = api.userSteps.getDirectJooqDbSteps().useShard(shard).perfCreativesSteps()
                .saveDefaultCanvasCreativesForClient(Long.parseLong(User.get(LOGIN).getClientID()));
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        Long cpmBannerAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        Long cpmVideoAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        cpmBannerAdId = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(cpmBannerAdGroupId, creativeId);
        cpmVideoAdId = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(cpmVideoAdGroupId, creativeId);
        api.userSteps.bannersFakeSteps().makeBannersModerated(cpmBannerAdId, cpmVideoAdId);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(cpmVideoAdGroupId, PhrasesAdgroupType.cpm_video);
    }

    @Test
    public void archiveCpmBannerAd() {
        api.userSteps.adsSteps().shouldGetResultOnArchive(
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(cpmBannerAdId)),
                ExpectedResult.success()
        );
    }

    @Test
    public void archiveCpmVideoAd() {
        api.userSteps.adsSteps().shouldGetResultOnArchive(
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(cpmVideoAdId)),
                ExpectedResult.success()
        );
    }
}
