package ru.yandex.autotests.direct.api.ads.archive;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.ArchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 16.04.15.
 * https://st.yandex-team.ru/TESTIRT-5211
 */
@Aqua.Test
@Features(AdsFeatures.ARCHIVE)
@Description("Проверка предупреждений при архивации объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
@Tag(TagDictionary.TRUNK)
public class CheckWarningsTest {

    private static final String CLIENT = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adGroupID;

    @BeforeClass
    public static void createAdGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);

        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @Description("Одинаковые идентификаторы в запросе на архивацию объявлений")
    public void sameAdIdsInRequest() {
        long adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adID);

        api.userSteps.adsSteps().shouldGetResultOnArchive(new ArchiveRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(adID, adID)),
                ExpectedResult.warnings(adID, new Notification(10000, Api5ErrorDetails.AD_MORE_THAN_ONCE_IN_REQUEST)),
                ExpectedResult.warnings(adID, new Notification(10000, Api5ErrorDetails.AD_MORE_THAN_ONCE_IN_REQUEST)));
    }

    @Test
    @Description("Заархивировать архивированное объвяление")
    public void archiveArchivedAd() {
        long adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adID);
        api.userSteps.adsSteps().adsArchive(adID);

        api.userSteps.adsSteps().shouldGetResultOnArchive(new ArchiveRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(adID)),
                ExpectedResult.warnings(adID, new Notification(10202)));
    }
}
