package ru.yandex.autotests.direct.api.ads.archive;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.ArchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 16.04.15.
 * https://st.yandex-team.ru/TESTIRT-5211
 */
@Aqua.Test
@Features(AdsFeatures.ARCHIVE)
@Description("Неправильный запрос на архивирование объвяления")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
public class InvalidRequestTest {
    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
    }

    @Test
    @Description("Пустой запрос")
    public void emptyRequest() {
        api.userSteps.adsSteps().expectErrorOnAdsArchive(new ArchiveRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(SuspendRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Пустой массив SelectionCriteria")
    public void emptySelectionCriteria() {
        api.userSteps.adsSteps().expectErrorOnAdsArchive(
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(IdsCriteriaMap.IDS)));
    }

    @Test
    @Description("Пустой массив Ids")
    public void emptyArrayOfIds() {
        api.userSteps.adsSteps().expectErrorOnAdsArchive(
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds()),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(SuspendRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS),
                        1));
    }

    @Test
    @Description("Заархивировать объявления за один запрос, число которых больше " + IdsCriteriaMap.IDS_MAX_LENGTH)
    public void archive10001Ads() {
        Long[] ids = new Long[IdsCriteriaMap.IDS_MAX_LENGTH + 1];
        Arrays.fill(ids, 0L);
        api.userSteps.adsSteps().expectErrorOnAdsArchive(
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)),
                new Api5Error(9300,
                        Api5ErrorDetails.ENABLE_ARCHIVE_NO_MORE_ADS_FOR_OPERATION, IdsCriteriaMap.IDS_MAX_LENGTH)
        );
    }
}
