package ru.yandex.autotests.direct.api.ads.archive;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 04.05.16.
 */
@Aqua.Test
@Features(AdsFeatures.ARCHIVE)
@Description("Проверка статуса StatusBsSynced после архивации объявления")
@Issue("https://st.yandex-team.ru/TESTIRT-9193")
@RunWith(Parameterized.class)
public class StatusBsSyncAfterArchiveAdTest {
    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long adGroupId;
    private Long adId1;
    private Long adId2;
    private GroupFakeInfo groupFakeInfo;

    @Parameterized.Parameter(0)
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameter(2)
    public BannerType bannerType;

    @Parameterized.Parameters(name = "bannerType = {2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE, BannerType.TEXT},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT},
                {CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createObjects() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        adId1 = api.userSteps.adsSteps().addDefaultAd(adGroupId, bannerType);
        adId2 = api.userSteps.adsSteps().addDefaultAd(adGroupId, bannerType);

        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);
        groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assumeThat("группе установился нужный статус синхронизации с БК",
                groupFakeInfo.getStatusBsSynced(), equalTo(Status.YES));

        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId1, Status.YES);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assumeThat("объявлению установился нужный статус синхронизации с БК",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
        api.userSteps.bannersFakeSteps().makeBannersModerated(adId2);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId2, Status.YES);
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assumeThat("объявлению установился нужный статус синхронизации с БК",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));

        api.userSteps.adsSteps().adsArchive(adId2);
    }

    @Test
    public void firstAdStatusBsSyncedAfterArchiveSecondAd() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-55528")
    public void secondAdStatusBsSyncedAfterArchive() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }

    @Test
    public void adGroupStatusBsSyncedAfterArchive() {
        groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                groupFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
    }
}
