package ru.yandex.autotests.direct.api.ads.delete;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 14.05.15.
 * https://st.yandex-team.ru/TESTIRT-5497
 */
@Aqua.Test
@Features(AdsFeatures.DELETE)
@Description("Удаление объявлений из разных групп в одной кампании")
@Issue("https://st.yandex-team.ru/DIRECT-39274")
@Tag(TagDictionary.TRUNK)
public class AdsFromDifferentAdGroupsTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long adId1;
    private Long adId2;

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId1 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId1);
        adId2 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId2);
    }

    @Test
    public void deleteTwoAdsFromDifferentAdGroups() {
        api.userSteps.adsSteps().shouldGetResultOnDelete(new IdsCriteriaMap()
                        .withIds(adId1, adId2),
                ExpectedResult.success(adId1), ExpectedResult.success(adId2));

        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withCampaignIds(campaignId))
                .withFieldNames(AdFieldEnum.ID));
        assumeThat("объявления удалились", response.getAds(), empty());
    }
}
