package ru.yandex.autotests.direct.api.ads.delete;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.emptyList;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 14.05.15.
 * https://st.yandex-team.ru/TESTIRT-5497
 */
@Aqua.Test
@Features(AdsFeatures.DELETE)
@Description("Удаление объявлений из разных кампаний")
@Issue("https://st.yandex-team.ru/DIRECT-39274")
@Tag(TagDictionary.TRUNK)
public class AdsFromDifferentCampaignsTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId1;
    private Long campaignId2;
    private Long adId1;
    private Long adId2;

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1);
        Long adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId2);
        adId1 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId1);
        adId2 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId2);
    }

    @Test
    public void deleteTwoAdsFromDifferentCampaigns() {
        api.userSteps.adsSteps().shouldGetResultOnDelete(new IdsCriteriaMap()
                        .withIds(adId1, adId2),
                ExpectedResult.success(adId1), ExpectedResult.success(adId2));

        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withCampaignIds(campaignId1, campaignId2))
                .withFieldNames(AdFieldEnum.ID));
        assumeThat("баннеры удалились", response.getAds(), equalTo(emptyList()));
    }
}
