package ru.yandex.autotests.direct.api.ads.delete;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 14.05.15.
 * https://st.yandex-team.ru/TESTIRT-5497
 */
@Aqua.Test
@Features(AdsFeatures.DELETE)
@Description("Проверка прав доступа агентства к объявлению при его удалении")
@Issue("https://st.yandex-team.ru/DIRECT-39274")
@RunWith(Parameterized.class)
public class AgencyCheckRightsToIdTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String client = AdsLogins.CLIENT;
    private static String agency = AdsLogins.AGENCY;
    private static String agencyRep = AdsLogins.AGENCY_REP;
    private static String agencyRepCl = AdsLogins.AGENCY_REP_CL;
    private static String subclient = AdsLogins.SUBCLIENT;
    private static String subclientElse = AdsLogins.SUBCLIENT_ELSE;

    private static Long clientAdGroupId;
    private static Long subclientAdGroupId;
    private static Long subclientElseAdGroupId;

    private Long clientAdId;
    private Long subclientAdId;
    private Long subclientElseAdId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agency},
                {agencyRep},
                {agencyRepCl}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createNotMineCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientElse, ShardNumbers.DEFAULT_SHARD);

        api.as(client);
        Long clientCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        clientAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(clientCampaignId);

        api.as(agency);
        Long subclientCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        subclientAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(subclientCampaignId, subclient);
        Long subclientElseCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclientElse);
        subclientElseAdGroupId =
                api.userSteps.adGroupsSteps().addDefaultGroup(subclientElseCampaignId, subclientElse);
    }

    @Before
    public void deleteAds() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        clientAdId = api.userSteps.adsSteps().addDefaultTextAd(clientAdGroupId);

        api.as(agency);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        subclientAdId = api.userSteps.adsSteps().addDefaultTextAd(subclientAdGroupId, subclient);
        subclientElseAdId = api.userSteps.adsSteps().addDefaultTextAd(subclientElseAdGroupId, subclientElse);

        api.as(loginForAuthorization);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
    }

    @Test
    public void callDeleteWithSubclientId() {
        api.userSteps.adsSteps().shouldGetResultOnDelete(
                new IdsCriteriaMap().withIds(subclientAdId),
                subclient,
                ExpectedResult.success(subclientAdId)
        );
    }

    @Test
    public void callDeleteWithSubclientElseId() {
        api.userSteps.adsSteps().shouldGetResultOnDelete(
                new IdsCriteriaMap().withIds(subclientElseAdId),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND))
        );
    }

    @Test
    public void callDeleteWithIdsOfBothSubclients() {
        api.userSteps.adsSteps().shouldGetResultOnDelete(
                new IdsCriteriaMap().withIds(subclientAdId, subclientElseAdId),
                subclient,
                ExpectedResult.success(subclientAdId),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND))
        );
    }

    @Test
    public void callDeleteWithClientId() {
        api.userSteps.adsSteps().shouldGetResultOnDelete(
                new IdsCriteriaMap().withIds(clientAdId),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND))
        );
    }
}
