package ru.yandex.autotests.direct.api.ads.delete;

import java.math.BigInteger;
import java.util.Random;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerTurbolandingsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersMinusGeoType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModObjectVersionObjType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatussending;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampMetrikaGoalsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampTurbolandingMetrikaCountersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.TurbolandingsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singleton;
import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertThat;
import static org.junit.Assume.assumeThat;
import static ru.yandex.autotests.direct.api.ads.AdsLogins.CLIENT;

@Aqua.Test
@Features(AdsFeatures.DELETE)
@Description("Удаление разных типов и всех связанных с ними объектов")
@Tag(TagDictionary.TRUNK)
public class DeleteAdsInterconnectionsTest {

    private static final Long CLIENT_ID = Long.parseLong(User.get(CLIENT).getClientID());
    private static final Random random = new Random();

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private int shard;
    private Long sitelinkSetId;
    private Long adExtensionId;
    private Long bannerAdditionId;
    private Long turbolandingId;
    private DirectJooqDbSteps directJooqDbSteps;
    private Long metricaGoalId;
    private Long campMetricaLinksCount;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Before
    public void setUp() {
        sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(3);
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        bannerAdditionId = directJooqDbSteps.bannerAdditionsSteps()
                .saveAdditionsItemDisclaimers(CLIENT_ID, RandomStringUtils.randomAlphanumeric(24));
        shard = directJooqDbSteps.shardingSteps().getShardByLogin(CLIENT);
    }

    @Test
    public void deleteTextAdTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        String adImageHash = api.userSteps.imagesStepsV5().addImage(ValidImageData.getValidRegularImage());
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap()
                        .defaultTextAd()
                        .withTitle2(TextAdAddMap.DEFAULT_TITLE_2)
                        .withDisplayUrlPath(TextAdAddMap.DEFAULT_DISPLAY_URL_PATH)
                        .withAdImageHash(adImageHash)
                        .withVCardId(vCardId)
                        .withSitelinkSetId(sitelinkSetId)
                        .withAdExtensionIds(adExtensionId))
                .withAdGroupId(adGroupId));
        assumeThat(directJooqDbSteps.imagesSteps().getBannerImagesByBid(adId), is(notNullValue()));
        addAdditionalItems(adId, campaignId);
        api.userSteps.adsSteps().adsDelete(adId);
        validate(adId, campaignId);
    }

    @Test
    public void deleteDynamicTextAdTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        String adImageHash = api.userSteps.imagesStepsV5().addImage(ValidImageData.getValidRegularImage());
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withDynamicTextAd(
                new DynamicTextAdAddMap()
                        .defaultDynamicTextAd()
                        .withText(TextAdAddMap.DEFAULT_TITLE_2)
                        .withAdImageHash(adImageHash)
                        .withVCardId(vCardId)
                        .withSitelinkSetId(sitelinkSetId)
                        .withAdExtensionIds(adExtensionId))
                .withAdGroupId(adGroupId));
        assumeThat(directJooqDbSteps.imagesSteps().getBannerImagesByBid(adId), is(notNullValue()));
        addAdditionalItems(adId, campaignId);
        api.userSteps.adsSteps().adsDelete(adId);
        validate(adId, campaignId);
    }

    @Test
    public void deleteTextImageAdTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        String adImageHash = api.userSteps.imagesStepsV5().addImage(ValidImageData.getValidImageAdImage());
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextImageAd(
                new TextImageAdAddMap()
                        .defaultTextImageAd(adImageHash))
                .withAdGroupId(adGroupId));
        addAdditionalItems(adId, campaignId);
        api.userSteps.adsSteps().adsDelete(adId);
        validate(adId, campaignId);
    }

    @Test
    public void deleteCreativeAdTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long creativeId = directJooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(CLIENT_ID);
        Long adId = api.userSteps.adsSteps().addDefaultTextAdBuilderAd(adGroupId, creativeId);
        addAdditionalItems(adId, campaignId);
        api.userSteps.adsSteps().adsDelete(adId);
        validate(adId, campaignId);
    }

    @Test
    public void deleteVideoCreativeAdTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long creativeId = directJooqDbSteps.perfCreativesSteps().saveDefaultVideoCreative(CLIENT_ID, 1L);
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(new TextAdAddMap()
                .defaultTextAd()
                .withVideoExtension(creativeId))
                .withAdGroupId(adGroupId));
        addAdditionalItems(adId, campaignId);
        api.userSteps.adsSteps().adsDelete(adId);
        validate(adId, campaignId);
    }

    @Test
    public void deleteMobileAdTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        String adImageHash = api.userSteps.imagesStepsV5().addImage(ValidImageData.getValidWideImage());
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withMobileAppAd(
                new MobileAppAdAddMap()
                        .defaultMobileAppAd()
                        .withText(TextAdAddMap.DEFAULT_TITLE_2)
                        .withAdImageHash(adImageHash))
                .withAdGroupId(adGroupId));
        addAdditionalItems(adId, campaignId);
        api.userSteps.adsSteps().adsDelete(adId);
        validate(adId, campaignId);
    }

    @Test
    public void deleteMobileImageAdTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        String adImageHash = api.userSteps.imagesStepsV5().addImage(ValidImageData.getValidImageAdImage());
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withMobileAppImageAd(
                new MobileAppImageAdAddMap().defaultMobileAppImageAd(adImageHash))
                .withAdGroupId(adGroupId));
        addAdditionalItems(adId, campaignId);
        api.userSteps.adsSteps().adsDelete(adId);
        validate(adId, campaignId);
    }

    @Test
    public void deleteMobileCreativeAdTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        Long creativeId = directJooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(CLIENT_ID);
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withMobileAppAdBuilderAd(
                new MobileAppAdBuilderAdAddMap().defaultMobileAppAdBuilderAd(creativeId))
                .withAdGroupId(adGroupId));
        addAdditionalItems(adId, campaignId);
        api.userSteps.adsSteps().adsDelete(adId);
        validate(adId, campaignId);
    }

    private void addAdditionalItems(Long adId, long campaignId) {
        addTurbolanding(campaignId, adId);
        assumeThat(directJooqDbSteps.shardingSteps().getShardByBidOrZero(adId), is(shard));

        directJooqDbSteps.bannersSteps().saveBannersMinusGeo(adId, BannersMinusGeoType.current, "1,2,3");
        directJooqDbSteps.bannerAdditionsSteps().saveBannerAdditions(adId, bannerAdditionId,
                BannersAdditionsAdditionsType.disclaimer);
        directJooqDbSteps.moderationSteps().getModReasonsRecord(adId, ModReasonsType.banner);
        directJooqDbSteps.bannerTurbolandingsSteps().linkTurbolandingToBanner(adId, campaignId, turbolandingId,
                false, BannerTurbolandingsStatusmoderate.Ready);
        directJooqDbSteps.bannerTurbolandingsSteps().addParamsToBannerTurbolanding(adId, "test");
        directJooqDbSteps.moderationSteps().createModObjectVersionRecord(ModObjectVersionObjType.banner,
                adId, "version");
        directJooqDbSteps.moderationSteps().createModReasonsRecord(adId, BigInteger.valueOf(10), campaignId,
                CLIENT_ID, "reason", ModReasonsStatusmoderate.Yes, ModReasonsStatuspostmoderate.Yes,
                ModReasonsStatussending.No, ModReasonsType.banner);
    }

    private void addTurbolanding(Long campaignId, Long adId) {
        turbolandingId = random.nextLong();
        metricaGoalId = random.nextLong();
        campMetricaLinksCount = (long) random.nextInt(30) + 1;
        directJooqDbSteps.turboLandingsSteps().addOrUpdate(new TurbolandingsRecord()
                .setTlId(turbolandingId)
                .setName("test")
                .setHref("test.com")
                .setTurboSiteHref("test.turbo.site")
                .setClientid(CLIENT_ID)
                .setMetrikaCountersJson(String.format("[{\"id\": %d, \"goals\": [%d]}]",
                        random.nextLong(), metricaGoalId)));
        directJooqDbSteps.campMetrikaGoalsSteps().addOrUpdateMetrikaGoals(new CampMetrikaGoalsRecord()
                .setGoalId(metricaGoalId)
                .setCid(campaignId)
                .setGoalsCount(1L)
                .setLinksCount(campMetricaLinksCount));
        directJooqDbSteps.campTurbolandingsMetricaCountersSteps()
                .createCampTurbolandingsMetricaCounters(new CampTurbolandingMetrikaCountersRecord()
                        .setBid(adId)
                        .setCid(campaignId)
                        .setMetrikaCounter(10L));
    }

    private void validate(Long adId, Long campaignId) {
        assertNull(directJooqDbSteps.bannersSteps().getBanner(adId));
        assertThat(directJooqDbSteps.bannersSteps().getBannersMinusGeo(adId), is(empty()));
        assertThat(directJooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecords(adId), is(empty()));
        assertNull(directJooqDbSteps.moderationSteps().getModReasonsRecord(adId, ModReasonsType.banner));
        assertNull(directJooqDbSteps.moderationSteps().getModObjectVersionRecord(ModObjectVersionObjType.banner, adId));
        assertNull(directJooqDbSteps.bannerDisplayHrefsSteps().getBannerDisplayHrefs(adId));
        assertNull(directJooqDbSteps.imagesSteps().getBannerImagesByBid(adId));
        assertThat(directJooqDbSteps.bannerTurbolandingsSteps().getBannerTurbolandings(adId), is(empty()));
        assertNull(directJooqDbSteps.bannerTurbolandingsSteps().getBannerTurbolandingParams(adId));
        assertThat(directJooqDbSteps.campMetrikaGoalsSteps().getCampMetrikaGoalRecord(campaignId, metricaGoalId)
                .getLinksCount(), is(campMetricaLinksCount - 1));
        assertThat(directJooqDbSteps.campTurbolandingsMetricaCountersSteps().getRecordByBid(adId), is(empty()));
        assertThat(directJooqDbSteps.bannersSteps().getDeletedBanners(singleton(adId)), contains(adId));
    }
}
