package ru.yandex.autotests.direct.api.ads.delete;

import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersPerformanceRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PerfCreativesRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;

@Aqua.Test
@Features(AdsFeatures.DELETE)
@Description("Проверка удаления cpc_video объявления РМП")
@Issue("https://st.yandex-team.ru/DIRECT-132279")
@Tag(TagDictionary.TRUNK)
public class DeleteMobileAppCpcVideoAdBuilderAdTest {

    private static final String CLIENT = AdsLogins.CLIENT48;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long mobileAppCpcVideoAd;
    private Long creativeId;

    @Before
    public void before() {
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(CLIENT).perfCreativesSteps()
                .saveDefaultCpcVideoCreative(Long.parseLong(User.get(CLIENT).getClientID()));

        api.as(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        mobileAppCpcVideoAd = api.userSteps.adsSteps().addDefaultMobileAppCpcVideoAdBuilderAd(adGroupId, creativeId);
    }

    @Test
    public void tryDelete() {
        api.userSteps.adsSteps().shouldGetResultOnDelete(new IdsCriteriaMap().withIds(mobileAppCpcVideoAd),
                ExpectedResult.success());

        BannersPerformanceRecord bannersPerformance = api.userSteps.getDirectJooqDbSteps().bannersPerformanceSteps()
                .getBannersPerformance(mobileAppCpcVideoAd, creativeId);
        assertThat("связка должна быть удалена", bannersPerformance, Matchers.nullValue());

        PerfCreativesRecord record =
                api.userSteps.getDirectJooqDbSteps().perfCreativesSteps().getPerfCreatives(creativeId);
        assertThat("креатив не должен быть удалён из базы", record, Matchers.notNullValue());
    }
}
