package ru.yandex.autotests.direct.api.ads.delete;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.emptyList;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 14.05.15.
 * https://st.yandex-team.ru/TESTIRT-5497
 */
@Aqua.Test
@Features(AdsFeatures.DELETE)
@Description("Пообъектная обработка запроса")
@Issue("https://st.yandex-team.ru/DIRECT-39274")
@Tag(TagDictionary.TRUNK)
public class DiscreteValidationTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long adId;

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    @Description("Удалить валидное и невалидное объявления")
    public void deleteValidAndInvalidAds() {
        api.userSteps.adsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(adId, -1L),
                        ExpectedResult.success(adId),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withCampaignIds(campaignId))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("объявление удалилось", response.getAds(), equalTo(emptyList()));
    }

    @Test
    @Description("Удалить невалидное и валидное объявления")
    public void deleteInvalidAndValidAds() {
        api.userSteps.adsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(-1L, adId),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)),
                        ExpectedResult.success(adId));
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withCampaignIds(campaignId))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("объявление удалилось", response.getAds(), equalTo(emptyList()));
    }

    @Test
    @Description("Удалить два невалидных объявления")
    public void deleteTwoInvalidAds() {
        api.userSteps.adsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(-1L, -2L),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }
}
