package ru.yandex.autotests.direct.api.ads.delete;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AccessRightsErrorHelper;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 14.05.15.
 * https://st.yandex-team.ru/TESTIRT-5497
 */
@Aqua.Test
@Features(AdsFeatures.DELETE)
@Description("Проверка прав внутренних ролей на удаление объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-39274")
@RunWith(Parameterized.class)
public class InternalRolesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String servClient = AdsLogins.SERV_CLIENT;

    static Long adId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public ExpectedResult expectedResult;

    @Parameterized.Parameter(2)
    public Api5Error expectedJavaError;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT, ExpectedResult.success(), null},
                {Logins.PLACER,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},
                {Logins.SUPPORT, ExpectedResult.success(), null},
                {Logins.SUPER_LOGIN, ExpectedResult.success(), null},
                {Logins.MEDIA,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},
                {Logins.SUPER_READER,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(servClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
        Long campaignId = api.as(Logins.MANAGER_DEFAULT).userSteps.campaignSteps().addDefaultTextCampaign(servClient);
        Long adGroupId = api.as(servClient).userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void checkRightsToDelete() {
        AccessRightsErrorHelper.checkCatchingJavaError54(expectedJavaError, () -> api.as(loginForAuthorization)
                .userSteps.adsSteps().shouldGetResultOnDelete(new IdsCriteriaMap().withIds(adId),
                        servClient, expectedResult));
    }
}
