package ru.yandex.autotests.direct.api.ads.delete;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 14.05.15.
 * https://st.yandex-team.ru/TESTIRT-5497
 */
@Aqua.Test
@Features(AdsFeatures.DELETE)
@Description("Неправильный формат JSON-запроса на удаление объявления")
@Issue("https://st.yandex-team.ru/DIRECT-39274")
public class InvalidJSONTest {
    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    @Description("Невалидное значение в params")
    public void invalidFieldInParams() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{adId});
        request.put(SuspendRequestMap.SELECTION_CRITERIA, idsCriteria);
        api.userSteps.adsSteps().expectErrorOnAdsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(SuspendRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Невалидное значение в SelectionCriteria")
    public void invalidFieldInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(IdsCriteriaMap.IDS, new Object[]{adId});
        request.put(capitalize(SuspendRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adsSteps().expectErrorOnAdsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(IdsCriteriaMap.IDS)));
    }

    @Test
    @Description("Массив в params")
    public void arrayInParams() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{adId});
        request.put(capitalize(SuspendRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adsSteps().expectErrorOnAdsDelete(
                new Object[]{request},
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_REQUEST_FORMAT)
        );
    }

    @Test
    @Description("Массив в SelectionCriteria")
    public void arrayInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{adId});
        request.put(capitalize(SuspendRequestMap.SELECTION_CRITERIA), new Object[]{idsCriteria});
        api.userSteps.adsSteps().expectErrorOnAdsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(SuspendRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Не массив в Ids")
    public void notArrayInIds() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), adId);
        request.put(capitalize(SuspendRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adsSteps().expectErrorOnAdsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path("SelectionCriteria", IdsCriteriaMap.IDS)));
    }

    @Test
    @Description("Строка в массиве Ids")
    public void arrayOfStringsInIds() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{"string"});
        request.put(capitalize(SuspendRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adsSteps().expectErrorOnAdsDelete(
                request,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path("SelectionCriteria", IdsCriteriaMap.IDS)));
    }
}
