package ru.yandex.autotests.direct.api.ads.delete;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 14.05.15.
 * https://st.yandex-team.ru/TESTIRT-5497
 */
@Aqua.Test
@Features(AdsFeatures.DELETE)
@Description("Неправильный запрос на удаление объвяления")
@Issue("https://st.yandex-team.ru/DIRECT-39274")
public class InvalidRequestTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Пустой запрос")
    public void emptyRequest() {
        api.userSteps.adsSteps().expectErrorOnAdsDelete(new DeleteRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(SuspendRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Пустой массив SelectionCriteria")
    public void emptySelectionCriteria() {
        api.userSteps.adsSteps().expectErrorOnAdsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(IdsCriteriaMap.IDS)));
    }

    @Test
    @Description("Пустой массив Ids")
    public void emptyArrayOfIds() {
        api.userSteps.adsSteps().expectErrorOnAdsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds()),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS),
                        1));
    }

    @Test
    @Description("Удалить объявления за один запрос, число которых больше " + IdsCriteriaMap.IDS_MAX_LENGTH)
    public void delete10001Ads() {
        Long[] ids = new Long[IdsCriteriaMap.IDS_MAX_LENGTH + 1];
        Arrays.fill(ids, 0L);
        api.userSteps.adsSteps().expectErrorOnAdsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)),
                new Api5Error(4001, Api5ErrorDetailsJava.ENABLE_DELETE_NO_MORE_ADS_FOR_OPERATION,
                        IdsCriteriaMap.IDS_MAX_LENGTH));
    }
}
