package ru.yandex.autotests.direct.api.ads.get;

import com.yandex.direct.api.v5.ads.AdCategoryEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ModerationFlag;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 22.05.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка массива AdCategories в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
public class AdCategoriesArrayTest {
    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adId;

    @Before
    public void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.bannersFakeSteps().setBannerFlags(adId,
                ModerationFlag.MEDICINE,
                ModerationFlag.ABORTION,
                ModerationFlag.TOBACCO,
                ModerationFlag.ALCOHOL,
                ModerationFlag.BABY_FOOD_0,
                ModerationFlag.DIETARY_SUPPL,
                ModerationFlag.PSEUDO_WEAPON);
    }

    @Test
    public void getAdCategories() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.AD_CATEGORIES));
        assertThat("вернулось правильное объявление",
                getResponse.getAds().get(0).getAdCategories().getValue().getItems(),
                containsInAnyOrder(
                        AdCategoryEnum.MEDICINE,
                        AdCategoryEnum.ABORTION,
                        AdCategoryEnum.TOBACCO,
                        AdCategoryEnum.ALCOHOL,
                        AdCategoryEnum.BABY_FOOD,
                        AdCategoryEnum.DIETARY_SUPPLEMENTS,
                        AdCategoryEnum.PSEUDO_WEAPON
                ));
    }
}
