package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;
import java.util.Collections;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdExtensionAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error.Common.maxIdsInSelectionCriteria;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 14.03.16.
 * https://st.yandex-team.ru/TESTIRT-8642
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка фильтрации по AdExtensionIds")
@Issue("https://st.yandex-team.ru/DIRECT-50728")
@Tag(TagDictionary.TRUNK)
public class AdExtensionIdsTest {

    private static String client = AdsLogins.CLIENT;
    private static String otherClient = AdsLogins.CLIENT_ELSE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adGroupId;
    Long adId;
    private Long adExtensionId;

    @Before
    public void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withAdExtensionIds(adExtensionId)).withAdGroupId(adGroupId));
    }

    @Test
    public void getOneAdExtensionId() {
        //DIRECT-41586
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(adExtensionId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_EXTENSIONS));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanEquivalentV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap().withAdExtensions(new AdExtensionAdGetItemMap()
                                .withAdExtensionId(adExtensionId)
                                .withType(AdExtensionTypeEnum.CALLOUT))).getBean())));
    }

    @Test
    public void getTwoAdExtensionIds() {
        Long adExtensionIdElse = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        Long adIdElse = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withAdExtensionIds(adExtensionIdElse)).withAdGroupId(adGroupId));
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(adExtensionId, adExtensionIdElse))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_EXTENSIONS));
        assertThat("вернулись правильные объявления", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                                .withTextAd(new TextAdGetMap().withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionId)
                                        .withType(AdExtensionTypeEnum.CALLOUT))).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(adIdElse)
                                .withTextAd(new TextAdGetMap().withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionIdElse)
                                        .withType(AdExtensionTypeEnum.CALLOUT))).getBean())));
    }

    @Test
    public void getOneAdExtensionIdTwoTimes() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(adExtensionId, adExtensionId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_EXTENSIONS));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanEquivalentV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap().withAdExtensions(new AdExtensionAdGetItemMap()
                                .withAdExtensionId(adExtensionId)
                                .withType(AdExtensionTypeEnum.CALLOUT))).getBean())));
    }

    @Test
    public void getWithMaxLengthOfAdExtensionIds() {
        Long[] adExtensionIds = new Long[AdsSelectionCriteriaMap.AD_EXTENSION_IDS_MAX_LENGTH];
        Arrays.fill(adExtensionIds, adExtensionId);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(adExtensionIds))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_EXTENSIONS));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanEquivalentV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap().withAdExtensions(new AdExtensionAdGetItemMap()
                                .withAdExtensionId(adExtensionId)
                                .withType(AdExtensionTypeEnum.CALLOUT))).getBean())));
    }

    @Test
    public void getWithOverMaxLengthOfAdExtensionIds() {
        Long[] adExtensionIds = new Long[AdsSelectionCriteriaMap.AD_EXTENSION_IDS_MAX_LENGTH + 1];
        Arrays.fill(adExtensionIds, adExtensionId);
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap()
                                .withCampaignIds(campaignId)
                                .withAdExtensionIds(adExtensionIds))
                        .withFieldNames(AdFieldEnum.ID),
                maxIdsInSelectionCriteria(AdsSelectionCriteriaMap.AD_EXTENSION_IDS,
                        AdsSelectionCriteriaMap.AD_EXTENSION_IDS_MAX_LENGTH));
    }

    @Test
    public void getNonExistentAdExtensionId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(adExtensionId + 10000))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getZeroAdExtensionId() {
        //DIRECT-41578
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(0L))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getNegativeAdExtensionId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(-adExtensionId))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getAdExtensionIdWithDeletedAd() {
        api.userSteps.adsSteps().adsDelete(adId);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(adExtensionId))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getUnbindedAdExtensionId() {
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap().withId(adId).withTextAd(new TextAdUpdateMap().withCalloutSetting(null))
        ));
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(adExtensionId))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getNotMyAdExtensionId() {
        api.as(otherClient);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(adExtensionId))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getAdExtensionIdWithTwoAds() {
        Long adIdElse = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withAdExtensionIds(adExtensionId)).withAdGroupId(adGroupId));
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(adExtensionId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_EXTENSIONS));
        assertThat("вернулись правильные объявления", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                                .withTextAd(new TextAdGetMap().withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionId)
                                        .withType(AdExtensionTypeEnum.CALLOUT))).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(adIdElse)
                                .withTextAd(new TextAdGetMap().withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionId)
                                        .withType(AdExtensionTypeEnum.CALLOUT))).getBean())));
    }

    @Test
    public void getTwoAdExtensionIdsBindedToOneAd() {
        Long adExtensionIdElse = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap().withId(adId).withTextAd(new TextAdUpdateMap()
                        .withCalloutSetting(new AdExtensionSettingMap()
                                .withAdExtensions(new AdExtensionSettingItemMap()
                                        .withOperation(OperationEnum.ADD)
                                        .withAdExtensionId(adExtensionIdElse))))
        ));
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdExtensionIds(adExtensionId, adExtensionIdElse))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_EXTENSIONS));
        assertThat("вернулись правильные объявления", getResponse.getAds(), beanEquivalentV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap().withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionId)
                                        .withType(AdExtensionTypeEnum.CALLOUT),
                                new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionIdElse)
                                        .withType(AdExtensionTypeEnum.CALLOUT))).getBean())));
    }
}
