package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 28.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка фильтрации по AdImageHashes")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
public class AdImageHashesTest {

    private static String client = AdsLogins.CLIENT2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    Long adId;
    private String adImageHash;
    private String[] hashes;

    @BeforeClass
    public static void createCampaign() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Before
    public void initTest() {
        api.as(client);
        hashes = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1, 2);
        adImageHash = hashes[0];
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withAdImageHash(adImageHash)).withAdGroupId(adGroupId));
    }

    @Test
    public void getOneAdImageHashByHash() {
        //DIRECT-41586
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdImageHashes(adImageHash))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_IMAGE_HASH));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap().withAdImageHash(adImageHash)).getBean())));
    }

    @Test
    public void getOneAdImageHashById() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_IMAGE_HASH));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap().withAdImageHash(adImageHash)).getBean())));
    }

    @Test
    public void getTwoAdImageHashIds() {
        String adImageHashElse = hashes[1];
        Long adIdElse = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withAdImageHash(adImageHashElse)).withAdGroupId(adGroupId));
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdImageHashes(adImageHash, adImageHashElse))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_IMAGE_HASH));
        assertThat("вернулись правильные объявления", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                                .withTextAd(new TextAdGetMap().withAdImageHash(adImageHash)).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(adIdElse)
                                .withTextAd(new TextAdGetMap().withAdImageHash(adImageHashElse)).getBean())));
    }

    @Test
    public void getOneAdImageHashTwoTimes() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdImageHashes(adImageHash, adImageHash))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_IMAGE_HASH));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap().withAdImageHash(adImageHash)).getBean())));
    }

    @Test
    public void getWithMaxLengthOfAdImageHashes() {
        String[] adImageHashes = new String[AdsSelectionCriteriaMap.ADIMAGE_HASHES_MAX_LENGTH];
        Arrays.fill(adImageHashes, adImageHash);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdImageHashes(adImageHashes))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_IMAGE_HASH));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap().withAdImageHash(adImageHash)).getBean())));
    }

    @Test
    public void getAdImageHashWithDeletedAd() {
        api.userSteps.adsSteps().adsDelete(adId);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdImageHashes(adImageHash))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getUnbindedAdImageHashByHash() {
        //DIRECT-42315
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap().withId(adId).withTextAd(new TextAdUpdateMap().withAdImageHash(null))
        ));
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdImageHashes(adImageHash))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getUnbindedAdImageHashById() {
        //DIRECT-42315
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap().withId(adId).withTextAd(new TextAdUpdateMap().withAdImageHash(null))
        ));
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_IMAGE_HASH));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap().withAdImageHash(null)).getBean())));
    }

    @Test
    public void getAdImageAfterReturnToAd() {
        //ToDo перенсти в Update
        //DIRECT-42315
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap().withId(adId).withTextAd(new TextAdUpdateMap().withAdImageHash(null))
        ));
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdImageHashes(adImageHash))
                .withFieldNames(AdFieldEnum.ID));
        assumeThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap().withId(adId)
                .withTextAd(new TextAdUpdateMap().withAdImageHash(adImageHash))), ExpectedResult.success());
        getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdImageHashes(adImageHash))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_IMAGE_HASH));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap().withAdImageHash(adImageHash)).getBean())));
    }

    @Test
    public void getAdImageHashWithTwoAds() {
        Long adIdElse = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withAdImageHash(adImageHash)).withAdGroupId(adGroupId));
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)
                        .withAdImageHashes(adImageHash))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_IMAGE_HASH));
        assertThat("вернулись правильные объявления", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                                .withTextAd(new TextAdGetMap().withAdImageHash(adImageHash)).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(adIdElse)
                                .withTextAd(new TextAdGetMap().withAdImageHash(adImageHash)).getBean())));
    }
}
