package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AgeLabelEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 28.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка поля AgeLabel в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AgeLabelTest {

    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    Long adId;

    @Parameterized.Parameter(0)
    public AgeLabelEnum ageLabel;

    @Parameterized.Parameters(name = "ageLabel = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {AgeLabelEnum.MONTHS_0},
                {AgeLabelEnum.MONTHS_1},
                {AgeLabelEnum.MONTHS_2},
                {AgeLabelEnum.MONTHS_3},
                {AgeLabelEnum.MONTHS_4},
                {AgeLabelEnum.MONTHS_5},
                {AgeLabelEnum.MONTHS_6},
                {AgeLabelEnum.MONTHS_7},
                {AgeLabelEnum.MONTHS_8},
                {AgeLabelEnum.MONTHS_9},
                {AgeLabelEnum.MONTHS_10},
                {AgeLabelEnum.MONTHS_11},
                {AgeLabelEnum.MONTHS_12},
                {AgeLabelEnum.AGE_0},
                {AgeLabelEnum.AGE_6},
                {AgeLabelEnum.AGE_12},
                {AgeLabelEnum.AGE_16},
                {AgeLabelEnum.AGE_18},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.as(Logins.SUPER_LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    public void initTest() {
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, client);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId, client);
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap().withId(adId)
                        .withTextAd(new TextAdUpdateMap().defaultAd().withAgeLabel(ageLabel))),
                client);
        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                        .withFieldNames(AdFieldEnum.ID, AdFieldEnum.AGE_LABEL),
                client);
        AgeLabelEnum adAgeLabel = response.getAds().get(0).getAgeLabel().getValue();
        assumeThat("объявлению установился правильный AgeLabel", adAgeLabel, equalTo(ageLabel));
    }

    @Test
    public void getAgeLabel() {
        //DIRECT-41335
        api.as(client);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.AGE_LABEL));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withAgeLabel(ageLabel).getBean())));
    }
}
