package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by pavryabov on 24.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка прав доступа агентства к кампаниям")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@RunWith(Parameterized.class)
public class AgencyCheckRightsToCampaignsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String client = AdsLogins.CLIENT;
    private static String agency = AdsLogins.AGENCY;
    private static String agencyRep = AdsLogins.AGENCY_REP;
    private static String agencyRepCl = AdsLogins.AGENCY_REP_CL;
    private static String subclient = AdsLogins.SUBCLIENT;
    private static String subclientElse = AdsLogins.SUBCLIENT_ELSE;

    private static Long subclientAdId;
    private static Long clientCampaignId;
    private static Long subclientCampaignId;
    private static Long subclientElseCampaignId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agency},
                {agencyRep},
                {agencyRepCl}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createAds() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientElse, ShardNumbers.DEFAULT_SHARD);
        api.as(client);
        clientCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long clientAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(clientCampaignId);
        api.userSteps.adsSteps().addDefaultTextAd(clientAdGroupId);
        api.as(agency);
        subclientCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        Long subclientAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(subclientCampaignId, subclient);
        subclientAdId = api.userSteps.adsSteps().addDefaultTextAd(subclientAdGroupId, subclient);
        subclientElseCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclientElse);
        Long subclientElseAdGroupId =
                api.userSteps.adGroupsSteps().addDefaultGroup(subclientElseCampaignId, subclientElse);
        api.userSteps.adsSteps().addDefaultTextAd(subclientElseAdGroupId, subclientElse);
    }

    @Test
    public void callGetWithSubclientCampaignId() {
        //DIRECT-41458
        GetResponse getResponse = api.as(loginForAuthorization).userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap().withCampaignIds(subclientCampaignId))
                        .withFieldNames(AdFieldEnum.ID),
                subclient
        );
        assertThat("Вернулось правильное объявление", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(subclientAdId).getBean())));
    }

    @Test
    public void callGetWithSubclientElseCampaignId() {
        GetResponse getResponse = api.as(loginForAuthorization).userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap().withCampaignIds(subclientElseCampaignId))
                        .withFieldNames(AdFieldEnum.ID),
                subclient
        );
        assertThat("Не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void callGetWithCampaignIdsOfBothSubclients() {
        GetResponse getResponse = api.as(loginForAuthorization).userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap()
                                .withCampaignIds(subclientCampaignId, subclientElseCampaignId))
                        .withFieldNames(AdFieldEnum.ID),
                subclient
        );
        assertThat("Вернулось правильное объявление", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(subclientAdId).getBean())));
    }

    @Test
    public void callGetWithClientCampaignId() {
        //DIRECT-41459
        GetResponse getResponse = api.as(loginForAuthorization).userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap().withCampaignIds(clientCampaignId))
                        .withFieldNames(AdFieldEnum.ID),
                subclient
        );
        assertThat("Не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }
}
