package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка того, что поле domain id не влияет на DisplayDomain")
@Issue("https://st.yandex-team.ru/DIRECT-83311")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class DomainIdTest {

    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adId;
    private static DirectJooqDbSteps dbSteps;

    @Parameterized.Parameter(0)
    public String href;

    @Parameterized.Parameter(1)
    public String expectedDisplayDomain;

    @Parameterized.Parameters(name = "Href = {0}, expected DisplayDomain = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"http://yandex.ru", "yandex.ru"},
                {"http://yandex.ru/404", "yandex.ru"},
                {"http://sdfergervgfgbhfg.ru", "sdfergervgfgbhfg.ru"},
                {"http://продвижение-статьями.рф", "продвижение-статьями.рф"},
                {"http://xn----8sbehgafpcd7bhhnp0arb4q8b.xn--p1ai/?utm_source=yandex&utm_medium=cpc&utm_campaign=" +
                        "elama-raskrutka-saitov&utm_term={keyword}&utm_content=region-msk-i-mo",
                        "продвижение-статьями.рф"},
                {null, null}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void init() {
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);
    }

    @Before
    public void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withTextAd(new TextAdAddMap().defaultTextAd().withHref(href).withVCardId(vCardId))
                .withAdGroupId(adGroupId));
        if (href != null) {
            BannersRecord record = dbSteps.bannersSteps().getBanner(adId);
            record.setDomainId(1L);
            dbSteps.bannersSteps().updateBanners(record);
        }
    }

    @Test
    public void checkDisplayDomain() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.DISPLAY_DOMAIN));

        assumeThat("Вернулся 1 баннер", getResponse.getAds(), hasSize(1));

        AdGetItem ad = getResponse.getAds().get(0);

        assertThat("Вернулся правильный домен", ad.getTextAd().getDisplayDomain().getValue(),
                is(expectedDisplayDomain));
    }
}
