package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.ads.AdCategoryEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdSubtypeEnum;
import com.yandex.direct.api.v5.ads.AdTypeEnum;
import com.yandex.direct.api.v5.ads.AgeLabelEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ModerationFlag;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdExtensionAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 28.05.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка соответствия возвращаемых полей, при запросе всех полей")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
public class FullRequestTest {
    private static String client = AdsLogins.CLIENT8;
    private static Long businessId = 1084861587L;
    private static YesNoEnum preferVCardOverBusiness = YesNoEnum.NO;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    static Long adId;
    private static String adImageHash;
    private static Long sitelinkSetId;
    private static Long vCardId;
    private static Long adExtensionId;
    private static Long turboPageId;

    @BeforeClass
    public static void initTest() {
        DirectJooqDbSteps jooqSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);
        long clientId = jooqSteps.usersSteps().getUser(client).getClientid();

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adImageHash = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1)[0];
        sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        turboPageId = jooqSteps.turboLandingsSteps().createDefaultTurbolanding(clientId);
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap()
                        .defaultTextAd()
                        .withTitle2(TextAdAddMap.DEFAULT_TITLE_2)
                        .withDisplayUrlPath(TextAdAddMap.DEFAULT_DISPLAY_URL_PATH)
                        .withAdImageHash(adImageHash)
                        .withVCardId(vCardId)
                        .withSitelinkSetId(sitelinkSetId)
                        .withAdExtensionIds(adExtensionId)
                        .withTurboPageId(turboPageId)
                        .withBusinessId(businessId)
                        .withPreferVCardOverBusiness(preferVCardOverBusiness))
                .withAdGroupId(adGroupId));
        api.userSteps.bannersFakeSteps().setBannerFlags(adId, ModerationFlag.BABY_FOOD_0);
    }

    @AfterClass
    public static void deleteTurboPages() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).turboLandingsSteps()
                .deleteTurboLandings(asList(turboPageId));
    }

    @Test
    public void getAdWithAllFields() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.values())
                .withTextAdFieldNames(TextAdFieldEnum.values()));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withCampaignId(campaignId)
                        .withStatus(StatusEnum.DRAFT)
                        .withAdCategories(AdCategoryEnum.BABY_FOOD)
                        .withState(StateEnum.OFF)
                        .withStatusClarification(StatusClarification.DRAFT.getStatusClarification())
                        .withType(AdTypeEnum.TEXT_AD)
                        .withSubtype(AdSubtypeEnum.NONE)
                        .withAgeLabel(AgeLabelEnum.MONTHS_0)
                        .withId(adId)
                        .withAdGroupId(adGroupId)
                        .withTextAd(new TextAdGetMap()
                                .withText(TextAdAddMap.DEFAULT_TEXT)
                                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                .withTitle2(TextAdAddMap.DEFAULT_TITLE_2)
                                .withHref(TextAdAddMap.DEFAULT_HREF)
                                .withDisplayUrlPath(TextAdAddMap.DEFAULT_DISPLAY_URL_PATH)
                                .withDisplayUrlPathModeration(
                                        new ExtensionModerationMap()
                                                .withStatus(StatusEnum.MODERATION)
                                                .withStatusClarification(
                                                        StatusClarification.DISPLAY_URL_PATH_AWAITING_MODERATION
                                                                .getStatusClarification())
                                )
                                .withDisplayDomain(TextAdAddMap.DEFAULT_DOMAIN)
                                .withVCardId(vCardId)
                                .withAdImageHash(adImageHash)
                                .withSitelinkSetId(sitelinkSetId)
                                .withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionId)
                                        .withType(AdExtensionTypeEnum.CALLOUT))
                                .withVCardModeration(
                                        new ExtensionModerationMap()
                                                .withStatus(StatusEnum.DRAFT)
                                                .withStatusClarification(
                                                        StatusClarification.DRAFT.getStatusClarification()))
                                .withSitelinksModeration(new ExtensionModerationMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withStatusClarification(
                                                StatusClarification.DRAFT.getStatusClarification()))
                                .withAdImageModeration(new ExtensionModerationMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withStatusClarification(
                                                StatusClarification.DRAFT.getStatusClarification()))
                                .withMobile(YesNoEnum.NO)
                                .withVideoExtension(null)
                                .withTurboPageId(turboPageId)
                                .withTurboPageModeration(new ExtensionModerationMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withStatusClarification(
                                                StatusClarification.DRAFT.getStatusClarification()))
                                .withBusinessId(businessId)
                                .withPreferVCardOverBusiness(preferVCardOverBusiness)
                        ).getBean())));
    }
}
