package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdSubtypeEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;

/**
 * Created by gerdler on 11.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка поля Subtype в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-54754")
@Tag(TagDictionary.TRUNK)
public class GetAdWithSubTypeTest {
    private static String client = AdsLogins.CLIENT42;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long textAdGroupId;
    private static Long mobileAppAdGroupId;
    private static Long dynamicTextAdGroupId;
    private static String adImageHash;
    private static DirectJooqDbSteps dbSteps;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        textAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        Long mobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);
        Long dynamicTextCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicTextCampaignId);
        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(1);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(client);
    }

    @Test
    public void getSubTypeOfTextAd() {
        Long textAdId = api.userSteps.adsSteps().addDefaultTextAd(textAdGroupId);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(textAdId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.SUBTYPE)
        );
        assertThat("вернулось объявление с правильным подтипом", getResponse.getAds(), beanDifferV5(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(textAdId).withSubtype(AdSubtypeEnum.NONE).getBean()))
        );
    }

    @Test
    public void getSubTypeOfTextImageAd() {
        Long textImageAdId = api.userSteps.adsSteps().addDefaultTextImageAd(textAdGroupId, adImageHash);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(textImageAdId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.SUBTYPE)
        );
        assertThat("вернулось объявление с правильным подтипом", getResponse.getAds(), beanDifferV5(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(textImageAdId).withSubtype(AdSubtypeEnum.TEXT_IMAGE_AD).getBean()))
        );
    }

    @Test
    public void getSubTypeOfMobileAppAd() {
        Long mobileAppAdId = api.userSteps.adsSteps().addDefaultMobileAppAd(mobileAppAdGroupId);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(mobileAppAdId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.SUBTYPE)
        );
        assertThat("вернулось объявление с правильным подтипом", getResponse.getAds(), beanDifferV5(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(mobileAppAdId).withSubtype(AdSubtypeEnum.NONE).getBean()))
        );
    }

    @Test
    public void getSubTypeOfMobileAppImageAd() {
        Long mobileAppImageAdId = api.userSteps.adsSteps().addDefaultMobileAppImageAd(mobileAppAdGroupId, adImageHash);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(mobileAppImageAdId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.SUBTYPE)
        );
        assertThat("вернулось объявление с правильным подтипом", getResponse.getAds(), beanDifferV5(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(mobileAppImageAdId).withSubtype(AdSubtypeEnum.MOBILE_APP_IMAGE_AD).getBean()))
        );
    }

    @Test
    public void getSubTypeOfCpcVideoAd() {
        Long creativeId = dbSteps.perfCreativesSteps().saveDefaultCpcVideoCreative(
                Long.parseLong(User.get(client).getClientID()));

        Long cpcVideoAdId = api.userSteps.adsSteps()
                .addDefaultCpcVideoAdBuilderAd(textAdGroupId, creativeId);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(cpcVideoAdId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.SUBTYPE)
        );
        assertThat("вернулось объявление с правильным подтипом", getResponse.getAds(), beanDifferV5(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap()
                                .withId(cpcVideoAdId)
                                .withSubtype(AdSubtypeEnum.NONE).getBean()))
        );
    }

    @Test
    public void getSubTypeOfMobileAppCpcVideoAd() {
        Long creativeId = dbSteps.perfCreativesSteps().saveDefaultCpcVideoCreative(
                Long.parseLong(User.get(client).getClientID()));

        Long mobileAppCpcVideoAdId = api.userSteps.adsSteps()
                .addDefaultMobileAppCpcVideoAdBuilderAd(mobileAppAdGroupId, creativeId);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(mobileAppCpcVideoAdId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.SUBTYPE)
        );
        assertThat("вернулось объявление с правильным подтипом", getResponse.getAds(), beanDifferV5(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap()
                                .withId(mobileAppCpcVideoAdId)
                                .withSubtype(AdSubtypeEnum.MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD).getBean()))
        );
    }

    @Test
    public void getSubTypeOfDynamicTextAd() {
        Long dynamicTextAdId = api.userSteps.adsSteps().addDefaultDynamicTextAd(dynamicTextAdGroupId);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(dynamicTextAdId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.SUBTYPE)
        );
        assertThat("вернулось объявление с правильным подтипом", getResponse.getAds(), beanDifferV5(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(dynamicTextAdId).withSubtype(AdSubtypeEnum.NONE).getBean()))
        );
    }

}
