package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 11.07.16.
 * https://st.yandex-team.ru/TESTIRT-9520
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Не должны получать данные кампаний типа: mcb, market, geo, wallet")
@Issue("https://st.yandex-team.ru/DIRECT-46973")
@RunWith(Parameterized.class)
public class GetInvalidCampaignTypeTest {
    private static String LOGIN = AdsLogins.CLIENT;
    private static Long campaignId;
    private static Long adGroupId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignsType campaignsType;

    @Parameterized.Parameters(name = "тип кампании - {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.GEO},
                {CampaignsType.MCB},
                {CampaignsType.WALLET},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createTestData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void initTest() {
        api.userSteps.campaignFakeSteps().setType(campaignId, campaignsType);
    }

    @Test
    public void getAdByCampaignId() {
        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withCampaignIds(campaignId)
                        )
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("объявления не получены", response.getAds(), hasSize(0));
    }

    @Test
    public void getAdByAdGroupId() {
        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withAdGroupIds(adGroupId)
                        )
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("объявления не получены", response.getAds(), hasSize(0));
    }
}
