package ru.yandex.autotests.direct.api.ads.get;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 28.07.17.
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Объявление типа mcbanner не поддерживается")
@Issue("https://st.yandex-team.ru/DIRECT-66999")
public class GetMcbannerAdTest {
    private static final String LOGIN = AdsLogins.CLIENT;
    private static Long campaignId;
    private static Long adGroupId;
    private static Long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createTestData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(1); //240x400
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                                        .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition()))));
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextImageAd(adGroupId, adImageHash);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adId);

        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.MCBANNER);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(adGroupId, PhrasesAdgroupType.mcbanner);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps()
                .setBannersBannerType(adId, BannersBannerType.mcbanner);
    }

    @Test
    public void getMcbannerAdById() {
        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withIds(adId)
                        )
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("объявление типа mcbanner не получено", response.getAds(), hasSize(0));
    }

    @Test
    public void getMcbannerAdByAdGroupId() {
        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withAdGroupIds(adGroupId)
                        )
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("объявления группы типа mcbanner не получены", response.getAds(), hasSize(0));
    }

    @Test
    public void getMcbannerAdByCampaignId() {
        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withCampaignIds(campaignId)
                        )
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("объявления кампании типа mcbanner не получены", response.getAds(), hasSize(0));
    }
}
